% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{get_bias}
\alias{get_bias}
\alias{root_mean_squared}
\alias{mean_absolute_error}
\title{Metric Functions}
\usage{
get_bias(predicted, observed, ...)

root_mean_squared(predicted, observed, ...)

mean_absolute_error(predicted, observed, ...)
}
\arguments{
\item{predicted}{Vector containing the predictions \emph{y}.}

\item{observed}{Vector containing the observations \emph{z}.}

\item{...}{\strong{relative} Boolean. If true give the result as a ratio to the
average observation \code{mean(ovserved)}.}
}
\value{
m A number representing the relative or absolute value for the
metric.
}
\description{
Functions to calculate different performance metrics.

In the case of \emph{get_bias}: Calculate the bias \emph{b}, i.e. the average
difference between predicted \emph{y} and observed \emph{z} values:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  bias = mean(y - z)
}\if{html}{\out{</div>}}
}
\section{Functions}{
\itemize{
\item \code{root_mean_squared()}: Calculate the square root of the average squared difference between
prediction and observation:

\if{html}{\out{<div class="sourceCode">}}\preformatted{RMSE = sqrt(sum(predicted - observed)^2) / length(predicted)
}\if{html}{\out{</div>}}

\item \code{mean_absolute_error()}: Calculate the average of the absolute differences between
prediction and observation:

\if{html}{\out{<div class="sourceCode">}}\preformatted{MAE = mean(abs(predicted - observed))
}\if{html}{\out{</div>}}

}}
\note{
NA values are completely ignored.
}
\examples{
predicted = c(21.5, 22.2, 19.1)
observed = c(20, 20, 20)
get_bias(predicted, observed)
get_bias(predicted, observed, relative = FALSE)

root_mean_squared(predicted, observed)
root_mean_squared(predicted, observed, relative = FALSE)

mean_absolute_error(predicted, observed)
mean_absolute_error(predicted, observed, relative = FALSE)

}
\seealso{
\code{\link[=willmott]{willmott()}}
}
