% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_scan.R
\name{PscanPlotter}
\alias{PscanPlotter}
\title{Plot Parameter Scan Results}
\description{
This class facilitates interactive visual analysis of parameter scan
results.
}
\seealso{
\code{\link[=plot_parameter_scan]{plot_parameter_scan()}}

\code{\link[=analyze_parameter_scan]{analyze_parameter_scan()}}

\code{PscanPlotter$plot()}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{analyzed}}{List, as output by \code{\link[=analyze_parameter_scan]{analyze_parameter_scan()}}.}

\item{\code{params}}{Vector of names of scanned parameters.}

\item{\code{metrics}}{Vector of names of model performance metrics to use.}

\item{\code{n_params}}{Number of scanned parameters.}

\item{\code{n_metrics}}{Number of performance metrics to apply.}

\item{\code{res}}{data.frame holding parameter scan results. It contains
\code{n_params + n_metrics + 1} columns: one column for each scanned
parameter, one for each employed metric and an additional column
(name \code{n}) to give each parameter combination (i.e. each row) an
identifying number.}

\item{\code{n_combinations}}{Number of rowns in \code{res}.}

\item{\code{sorted}}{List containing copies of \code{res} which are each sorted by
a different performance metric. List keys are the values in
\code{self$metrics}.}

\item{\code{selection}}{Vector of integers corresponding to the ID number of
combinations (column \code{n} in \code{self$res}) that is to be highlighted.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PscanPlotter-new}{\code{PscanPlotter$new()}}
\item \href{#method-PscanPlotter-set_variable}{\code{PscanPlotter$set_variable()}}
\item \href{#method-PscanPlotter-analyze}{\code{PscanPlotter$analyze()}}
\item \href{#method-PscanPlotter-plot}{\code{PscanPlotter$plot()}}
\item \href{#method-PscanPlotter-print_info}{\code{PscanPlotter$print_info()}}
\item \href{#method-PscanPlotter-clone}{\code{PscanPlotter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PscanPlotter-new"></a>}}
\if{latex}{\out{\hypertarget{method-PscanPlotter-new}{}}}
\subsection{Method \code{new()}}{
Construct and set up a \link{PscanPlotter} instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PscanPlotter$new(analyzed, variable = "dBM")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{analyzed}}{List; Output of \code{\link[=analyze_parameter_scan]{analyze_parameter_scan()}}.}

\item{\code{variable}}{Str; Name of variable in \emph{analyzed} to visualize. Can
be changed later with \code{set_variable()}. Allowed values are the keys
in \emph{analyzed} except for \code{params} and \code{metrics}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PscanPlotter-set_variable"></a>}}
\if{latex}{\out{\hypertarget{method-PscanPlotter-set_variable}{}}}
\subsection{Method \code{set_variable()}}{
Choose which variable to visualize.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PscanPlotter$set_variable(variable)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variable}}{Chosen variable name. One of "dBM", "cBM", "cBM_end"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PscanPlotter-analyze"></a>}}
\if{latex}{\out{\hypertarget{method-PscanPlotter-analyze}{}}}
\subsection{Method \code{analyze()}}{
Enter analysis loop.

This plots the analysis results and enters a simple command-line
interface through which more insights can be gathered. Particularly,
it allows highlighting specific parameter combinations, either by
their index number or by selecting the best performers according to a
given metric.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PscanPlotter$analyze()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PscanPlotter-plot"></a>}}
\if{latex}{\out{\hypertarget{method-PscanPlotter-plot}{}}}
\subsection{Method \code{plot()}}{
Plot parameter scan results.

For every combination of scanned parameter and metric, a subplot is
generated in which the parameter values are plotted against
performance score in that metric for every parameter combination.

The result of this is static. Use \code{PscanPlotter$analyze()}
for an interactive version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PscanPlotter$plot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PscanPlotter-print_info"></a>}}
\if{latex}{\out{\hypertarget{method-PscanPlotter-print_info}{}}}
\subsection{Method \code{print_info()}}{
Print information on selected parameter combinations.

The parameter values and performance scores of all combinations
referred to by the integers in \emph{selection} are printed to console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PscanPlotter$print_info(selection)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{selection}}{Vector of integers representing IDs of parameter
combinations (i.e. column \code{n} in \code{self$res}).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PscanPlotter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PscanPlotter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PscanPlotter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
