#' growR: R implementation of the grass growth model ModVege.
#'
#' @import R6
#' @import utils
#' @importFrom Rdpack reprompt
#'
#' @keywords internal
"_PACKAGE"

globalVariables(c("yield_parameters",
                  "management_parameters"))

#' Default options introduced by package growR
#'
#' @description These are the default options, set when the package is loaded 
#'   by `library(growR)`. To get or change the current value of an option, 
#' use the `options()` function.
#'
#' \describe{
#'   \item{growR.verbosity}{Integer that controls how much console output is 
#'         generated by growR functions. Higher numbers mean more output. 
#'         See [logger()].}
#'   \item{growR.input_dir}{Name of the directory in which to look for 
#'         input files.}
#'   \item{growR.output_dir}{Name of the directory into which output files
#'         are written.}
#'   \item{growR.data_dir}{Name of the directory in which to look for 
#'         measured data files.}
#' }
#'
#' @seealso [options()]
#'
#' @export
growR_package_options = list(
  growR.verbosity = 3,
  growR.input_dir = "input/",
  growR.output_dir = "output/",
  growR.data_dir = "data/"
  )

# This is run when the package is loaded
.onAttach = function(...) {
  growR_version = packageVersion("growR")
  message = sprintf("| Welcome to growR Version %s! |", growR_version)
  line = paste0("+", paste(rep("-", nchar(message) - 2), collapse = ""), "+")
  packageStartupMessage(paste0(line, "\n", message, "\n", line, "\n"))
  # Set package options
  options(growR_package_options)
}
