% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FAnova.R
\name{FAnova}
\alias{FAnova}
\title{Bayesian functional ANOVA}
\usage{
FAnova(W, X, formula, nu = 5, is.kappa.fixed = FALSE, gamma.kappa = 0.3,
  eta.kappa = 0.1, n.samples = 500, transition.mode = "Markov",
  method = "Nelder-Mead")
}
\arguments{
\item{W}{An object of class \code{DWT}.}

\item{X}{Design matrix.}

\item{formula}{An object of class formula.}

\item{nu}{Hyperparameter controlling the heterogeneity in the noise variance.}

\item{is.kappa.fixed}{If \code{TRUE}, gamma.kappa and eta.kappa are fixed.
If \code{FALSE} gamma_kappa and eta_kappa are determined using Empirical Bayes.}

\item{gamma.kappa}{Hyperparameter for the MT transition matrix.}

\item{eta.kappa}{Hyperparameter for the MT transition matrix.}

\item{n.samples}{Number of posterior draws.}

\item{transition.mode}{Type of transition. The two options are \code{Markov}
or \code{Independent}.}

\item{method}{Method used for find maxmimum of marginal likelihood.}
}
\value{
An object of class \code{grove}.
}
\description{
This function carries out Bayesian functional ANOVA using the
Normal Inverse Gamma Markov Grove method of Ma and Soriano (2016).
}
\examples{
\dontrun{
data <- GenerateSyntheticAnova(st.dev = 5, n.replicates = 5)
W <- DWT(data$noisy.Y)
X <- data$X
ans <- FAnova(W, X, ~ 1 + factorA + factorB)
denoised.data <- InvDWT(ans, x = c(0, 0, 1, 0))
PlotFun(denoised.data)}
}
\references{
Ma L. and Soriano J. (2016) Efficient functional ANOVA
through wavelet-domain Markov groves. arXiv:1602.03990v2 [stat.ME]
(\url{https://arxiv.org/abs/1602.03990v2}).
}

