% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwqs.fit.R
\name{gwqs.fit}
\alias{gwqs.fit}
\title{Grouped WQS Regression}
\usage{
gwqs.fit(
  y,
  y.train = NULL,
  x,
  x.train = NULL,
  z = NULL,
  z.train = NULL,
  x.s,
  B = 100,
  n.quantiles = 4,
  pars = NULL,
  func,
  ineqLB = NULL,
  ineqUB = NULL,
  tol = 1e-06,
  delta = 1e-06
)
}
\arguments{
\item{y}{A vector containing outcomes for validation.}

\item{y.train}{A vector containing outcomes for training. If left as NULL the validation data will be used for training as well.}

\item{x}{A matrix of component data for validation.}

\item{x.train}{A matrix of component data for training. If left as NULL the validation data will be used for training as well.}

\item{z}{A vector or matrix of covariates for validation.}

\item{z.train}{A vector or matrix of covariates for training. If left as NULL the validation data will be used for training as well.}

\item{x.s}{A vector of the number of components in each index.}

\item{B}{The number of bootstrap samples, must be 1 or more.}

\item{n.quantiles}{The number of quantiles to apply to data.}

\item{pars}{A vector of initial values, listed in order: beta naught intercept and group index beta coefficients, individual chemical weight coefficients, and covariate coefficients.}

\item{func}{The objective function to be used (must match outcome data type); currently only fun args "continuous" or "binary" are supported.}

\item{ineqLB}{Vector of lower bounds for betas and weights, set to -2 by default.}

\item{ineqUB}{Vector of upper bounds for betas and weights, set to 2 be default.}

\item{tol}{Tolerance level for bootstrap convergence.}

\item{delta}{Step size for bootstrap procedure.}
}
\value{
A list of 3 containing the GWQS estimate based on calculated weights, the GWQS model fit to validation data, and weight estimates
}
\description{
This function fits a grouped weighted quantile sum (GWQS) regression model.
}
\examples{
data("WQSdata")
group_list <- list(c("X1", "X2", "X3"), c("X4", "X7"), c("X5", "X6", "X9", "X8"))
x.s <- make.x.s(WQSdata, 3, group_list)
X <- make.X(WQSdata, 3, group_list)
Y <- WQSdata$y
results <- gwqs.fit(y = Y, x = X, x.s = x.s, B=1, func = "continuous")

}
