% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_page_views_per_session.R
\name{sample_page_views_per_session}
\alias{sample_page_views_per_session}
\title{Sample Page Views Per Session (Visit)}
\usage{
sample_page_views_per_session(input_df, priors, n_samples = 50000)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str),
sum_sessions (dbl), and sum_page_views_per_session (dbl).}

\item{priors}{Optional list of priors k0 and theta0.
Default \eqn{Gamma(1, 250)} will be use otherwise.
\eqn{Gamma(1, 1)} might also be a good choice for this distribution
if you only have a few page views per session.}

\item{n_samples}{Optional integer value. Defaults to 50,000 samples.}
}
\value{
input_df with 2 new nested columns `gamma_params` and `samples`
}
\description{
Adds 2 new nested columns to the input_df: `gamma_params` and `samples`
    `gamma_params` in each row should be a tibble of length 2 (\eqn{k}
        and \eqn{\theta} parameters)
    `samples` in each row should be a tibble of length `n_samples`
}
\details{
See update_rules vignette for a mathematical representation.
\deqn{page_views_i ~ Poisson(\lambda)}
\deqn{\lambda ~ Gamma(k, \theta)}
Page Views Per Visit is sampled from a Gamma distribution with a Poisson likelihood
of an individual having n page views by the end of their session.

This is not always the case, so verify your data follows the shape of
an Poisson distribution before using this.
}
