% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_inp.R
\name{write_inp}
\alias{write_inp}
\title{Write \code{gretl} \code{inp} file in R}
\usage{
write_inp(code,path)
}
\arguments{
\item{code}{Object or a character string representing the set of \code{gretl} codes}

\item{path}{Object or a character string representing the path to write the \code{gretl} \code{inp} file.}
}
\value{
Set of \code{gretl} (open-source software for Econometrics) outputs
}
\description{
Use this function to write \code{gretl} \code{inp} file in R
}
\examples{
library(gretlR)
\dontrun{
code=r'(nulldata 500
set seed 13
gretl1 = normal()
gretl2 = normal()
setobs 12 1980:01 --time-series
gnuplot gretl1 --time-series --with-lines --output="line.png"
gnuplot gretl2 gretl1 --output="scatter.png"
)'
write_inp(code,path="gretlCodes")
}
}
\seealso{
Other important functions: 
\code{\link{eng_gretl}()},
\code{\link{exec_gretl}()},
\code{\link{exec_inp}()},
\code{\link{gretlR}},
\code{\link{import_kable}()},
\code{\link{include_graph}()},
\code{\link{include_tex}()}
}
\concept{important functions}
\keyword{documentation}
