% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregory_all.R
\name{gregory_all}
\alias{gregory_all}
\title{gregory_all}
\usage{
gregory_all(
  plot_df,
  resolution,
  estimation,
  pixel_estimation_means,
  proportions,
  formula,
  prop
)
}
\arguments{
\item{plot_df}{A data frame containing the response variable, predictors, estimation unit, and resolution unit for each "plot"}

\item{resolution}{A character specifying the resolution column name within the other dataframes}

\item{estimation}{A character specifying the estimation column name within the other dataframes}

\item{pixel_estimation_means}{A dataframe with a column for the estimation unit and a column for the mean response variable value per that estimation unit}

\item{proportions}{A dataframe with three columns: one for resolution, one for estimation, and one for the proportion of a resolution area found in each estimation area}

\item{formula}{Formula to be used for the model, names should be consistent with the column names in plot_df and pixel_estimation_means}

\item{prop}{A character specifying the column name of the proportion found in proportions}
}
\value{
A dataframe with each row representing each estimation unit, its estimate, and its estimated variance.
}
\description{
This function runs the Generalized Regression Operating on Resolutions of Y estimator, also know as GREGORY, on a set of data.
}
\examples{
#create plot data
planet_plot_data <- data.frame(plot_number = 1:20,
                               planet = c(rep("Kashyyyk", 5),
                                          rep("Forest Moon of Endor", 5),
                                          rep("Dagobah", 5),
                                          rep("Naboo", 5)),
                               count_of_trees = c(204, 156, 240, 286, 263,
                                                  112, 167, 131, 25, 145,
                                                  141, 65, 127, 15, 98,
                                                  100, 12, 49, 94, 69),
                               forest_cover = c(85, 74, 89, 95, 92,
                                                70, 73, 69, 11, 68,
                                                67, 30, 62, 15, 42,
                                                59, 5, 17, 25, 22),
                               eco_province = c("forest", "swamp", "forest", "forest", "forest",
                                                "forest", "forest", "forest", "grassland", "forest",
                                                "forest", "swamp", "swamp", "grassland", "swamp",
                                                "forest", "grassland", "grassland",
                                                "swamp", "swamp"))

#create mean data
planet_means <- data.frame(planet = c("Kashyyyk",
                                      "Forest Moon of Endor",
                                      "Dagobah",
                                      "Naboo"),
                           forest_cover = c(95,
                                            85,
                                            50,
                                            30))
#create proportion data
planet_province_prop <- data.frame(planet = c(rep("Kashyyyk", 2),
                                              rep("Forest Moon of Endor", 2),
                                              rep("Dagobah", 3),
                                              rep("Naboo", 3)),
                                   eco_province = c("forest", "swamp",
                                                    "forest", "grassland",
                                                    "forest", "grassland", "swamp",
                                                    "forest", "grassland", "swamp"),
                                   prop = c(0.8, 0.2,
                                            0.75, 0.25,
                                            0.1, 0.1, 0.8,
                                            0.2, 0.4, 0.4))

x1 <- gregory_all(plot_df = planet_plot_data,
                  resolution = "eco_province",
                  estimation = "planet",
                  pixel_estimation_means = planet_means,
                  proportions = planet_province_prop,
                  formula = count_of_trees ~ forest_cover,
                  prop = "prop")
x1
}
\keyword{forest}
