% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greenplot.R
\name{greenplot}
\alias{greenplot}
\title{Plot Statistics for a Greenclust Object}
\usage{
greenplot(
  g,
  type = "b",
  bg = "gray75",
  pch = 21,
  cex = 1,
  optim.col = "red",
  pos = 2,
  main = "P-Value vs. R-Squared for Num. Clusters",
  xlab = "r-squared",
  ylab = NULL,
  ...
)
}
\arguments{
\item{g}{an object of the type produced by \code{\link{greenclust}}}

\item{type}{1-character string giving the type of plot desired: "p" for
points, "l" for lines, and "b" (the default) for both points and lines.}

\item{bg}{a vector of background colors for open plot symbols. Also used
for the line color if type is "b".}

\item{pch}{a vector of plotting characters or symbols: see
\code{\link{points}}}

\item{cex}{a numerical vector giving the amount by which plotting
characters and symbols should be scaled relative to the default. For
this plot, the numeric labels on each point are always scaled to
0.80 of this value.}

\item{optim.col}{color to use for highlighting the "optimal" cutpoint.}

\item{pos}{specifies the position of labels relative to their points:
1 = below, 2 = left, 3 = above, and 4 = right.}

\item{main}{an overall title for the plot.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{...}{additional arguments to be passed to the plotting methods.}
}
\description{
Displays a connected scatterplot showing the r-squared values (x-axis) and
p-values (y-axis) at each clustering step of a \code{\link{greenclust}}
object. Points are labeled with their cutpoints, i.e., the number of
groups/clusters found at each step. The point with the lowest p-value
(typically the optimal cutpoint) is highlighted.
}
\examples{
# Combine Titanic passenger attributes into a single category
# and create a contingency table for the non-zero levels
tab <- t(as.data.frame(apply(Titanic, 4:1, FUN=sum)))
tab <- tab[apply(tab, 1, sum) > 0, ]

grc <- greenclust(tab)
greenplot(grc)


# Plot using custom graphical parameters
greenplot(grc, type="p", bg="lightblue", optim.col="darkorange",
          pos=3, bty="n", cex.main=2, col.main="blue")
}
\references{
Greenacre, M.J. (1988) "Clustering the Rows and Columns of
  a Contingency Table," \emph{Journal of Classification 5}, 39-51.
  \doi{10.1007/BF01901670}
}
\seealso{
\code{\link{greenclust}}, \code{\link{greencut}},
    \code{\link{assign.cluster}}
}
