% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ets_model.R
\name{ets_model}
\alias{ets_model}
\title{Specify parameters for an ETS model}
\usage{
ets_model(
  frequency = 1,
  error = NULL,
  trend = NULL,
  seasonal = NULL,
  alpha = NULL,
  beta = NULL,
  gamma = NULL,
  phi = NULL,
  level = NULL,
  slope = NULL,
  season = NULL,
  damped = NULL,
  sigma = NULL
)
}
\arguments{
\item{frequency}{The length of the seasonal period (e.g., 12 for monthly data).}

\item{error}{A character string specifying the error part of the ETS model: either "A" or "M".}

\item{trend}{A character string specifying the trend part of the ETS model: either "N", "A" or "Ad".}

\item{seasonal}{A character string specifying the seasonal part of the ETS model: either "N", "A" or "M".}

\item{alpha}{A numeric value for the smoothing parameter controlling the level.}

\item{beta}{A numeric value for the smoothing parameter controlling the trend.}

\item{gamma}{A numeric value for the smoothing parameter controlling the seasonality.}

\item{phi}{A numeric value specifying the damping parameter.}

\item{level}{A numeric value specifying the initial level \eqn{\ell_0}.}

\item{slope}{A numeric value specifying the initial slope \eqn{b_0}}

\item{season}{A numeric vector specifying the initial states \eqn{s_{1-m},...,s_0}.}

\item{damped}{A logical value indicating if the trend is damped or not.}

\item{sigma}{The standard deviation of the noise.}
}
\value{
An `ets` object as described in the \code{\link[forecast]{ets}} function from the forecast package.
}
\description{
This function allows the parameters of a ETS state space model to be specified.
The output can be used in \code{\link[forecast]{simulate.ets}()}
and \code{\link{generate.ets}}.
If any argument is \code{NULL}, the corresponding parameters are randomly selected.
The error component is chosen from \{A,M\}, the trend component is chosen from
\{N,A,Ad\}, and the seasonal component is chosen from \{N,A,M\}. In all cases,
the component is selected uniformly on the options. The parameters are selected
uniformly on the forecastable parameter space. The noise variance sigma
is uniformly sampled on (1,5) for additive errors, and on (0.0001,0.05) for
multiplicative errors. The initial states are chosen uniformly on (-1,1)
in all cases except for multiplicative seasonal states which are uniform on
(0.5, 1.5), and models with multiplicative errors for which the level is uniform
on (2, 10). The parameterization is as specified in Hyndman & Athanasopoulos (2021).
}
\examples{
# An ETS(A,A,N) model with random parameters
model1 <- ets_model(error = "A", trend = "A", seasonal = "N")
# An ETS(A,A,N) model with specific parameters
model2 <- ets_model(
  error = "A", trend = "A", seasonal = "N",
  alpha = 0.3, beta = 0.2, level = 0, slope = 1, sigma = 2
)
# A multiplicative quarterly seasonal ETS model with random parameters
model3 <- ets_model(seasonal = "M", frequency = 4)
# Simulate from each model and plot the results
library(forecast)
simulate(model1, 100) \%>\% plot()
simulate(model2, 100) \%>\% plot()
simulate(model3, 100) \%>\% plot()
}
\seealso{
\code{\link[forecast]{simulate.ets}}
}
\author{
Rob J Hyndman
}
