% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route-endpoint.R
\name{gh_get_route}
\alias{gh_get_route}
\title{Get a route for a given set of points}
\usage{
gh_get_route(points, ..., response_only = FALSE)
}
\arguments{
\item{points}{A list of 2 or more points as (lat, lon) pairs.}

\item{...}{Optional parameters that are passed to the query.}

\item{response_only}{Whether to return the raw response object instead of
just its content.}
}
\description{
Get a route for a given set of points
}
\examples{
if (FALSE) {
  start_point <- c(52.592204, 13.414307)
  end_point <- c(52.539614, 13.364868)

  route_sf <- gh_get_route(list(start_point, end_point)) \%>\%
    gh_as_sf()
}
}
\seealso{
\url{https://docs.graphhopper.com/#tag/Routing-API} for optional parameters.
}
