% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochrone-endpoint.R
\name{gh_get_isochrone}
\alias{gh_get_isochrone}
\title{Get isochrones for a given start point}
\usage{
gh_get_isochrone(start_point, time_limit = 180, distance_limit = -1,
  ...)
}
\arguments{
\item{start_point}{The start point as (lat, lon) pair.}

\item{time_limit}{The travel time limit in seconds.
Ignored if \code{distance_limit > 0}.}

\item{distance_limit}{The distance limit in meters.}

\item{...}{Additonal parameters.
See \url{https://docs.graphhopper.com/#operation/getIsochrone}.}
}
\description{
Get isochrones for a given start point
}
\examples{
if (FALSE) {
  start_point <- c(52.53961, 13.36487)

  isochrone_sf <- gh_get_isochrone(start_point, time_limit = 180) \%>\%
    gh_as_sf()
}
}
