% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Granger_unconditional.R
\name{Granger.unconditional}
\alias{Granger.unconditional}
\title{Unconditional Granger-causality estimation}
\usage{
Granger.unconditional(x, y, ic.chosen = "SC", max.lag = min(4,
  length(x) - 1), plot = F, type.chosen = "none", p = 0)
}
\arguments{
\item{x}{univariate time series.}

\item{y}{univariate time series (of the same length of \verb{x}).}

\item{ic.chosen}{estimation method parameter \verb{ic} to be passed to function \link[vars]{VAR} of
package \href{https://CRAN.R-project.org/package=vars}{vars}. Defaults to ''SC'' (Schwarz criterion). Alternatives are \verb{c(''AIC'',''HQ'',''SC'',''FPE'')}.}

\item{max.lag}{maximum number of lags \verb{lag.max} to be passed to function \link[vars]{VAR}.
Defaults to \verb{min(4, length(x) - 1)}.}

\item{plot}{logical; if TRUE, it returns the plot of unconditional Granger-causality
spectra on both directions. Defaults to FALSE.}

\item{type.chosen}{parameter \verb{type} to be passed to function \link[vars]{VAR}.
Defaults to \verb{''none''}. Alternatives are \verb{c(''none'',''const'',''trend'')}.}

\item{p}{parameter \verb{p} to be passed to function \link[vars]{VAR}.
Defaults to 0.}
}
\value{
\verb{frequency}: frequencies used by Fast Fourier Transform.

\verb{n}: time series length.

\verb{Unconditional_causality_y.to.x}: computed unconditional Granger-causality from \verb{y} to \verb{x}.

\verb{Unconditional_causality_x.to.y}: computed unconditional Granger-causality from \verb{x} to \verb{y}.

\verb{roots}: the roots of the estimated VAR on \verb{x} and \verb{y}.

The result is returned invisibly if plot is TRUE.
}
\description{
Unconditional Granger-causality spectrum was first defined in Geweke (1982).
It measures the strength of the causal link from time series \verb{y} to time series \verb{x} and
viceversa in the frequency domain. It needs to estimate a VAR model on \verb{x} and \verb{y}
by package \href{https://CRAN.R-project.org/package=vars}{vars}. For computational details we refer to Ding et al. (2006).
}
\details{
\verb{Granger.unconditional} calculates the Granger-causality unconditional spectrum of
	a time series \verb{x} (effect variable) respect to a time series \verb{y} (cause variable).
	It requireNamespaces package \href{https://CRAN.R-project.org/package=vars}{vars}.
}
\examples{
RealGdp.rate.ts<-euro_area_indicators[,1]
m3.rate.ts<-euro_area_indicators[,2]
uncond_m3<-Granger.unconditional(RealGdp.rate.ts,m3.rate.ts,"SC",4)
}
\references{
Geweke, J., 1982. Measurement of linear dependence and feedback between
multiple time series. \emph{J. Am. Stat. Assoc}. \bold{77}, 304--313.

Ding, M., Chen, Y., Bressler, S.L., 2006. Granger Causality: Basic Theory and
	Application to Neuroscience, Chap.17. \emph{Handbook of Time Series Analysis
	Recent Theoretical Developments and Applications}.

Farne', M., Montanari, A., 2018. A bootstrap test to detect prominent Granger-causalities across frequencies. 
<arXiv:1803.00374>, \emph{Submitted}.
}
\seealso{
\link[vars]{VAR}.
}
\author{
Matteo Farne', Angela Montanari, \email{matteo.farne2@unibo.it}
}
