% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Granger_conditional.R
\name{Granger.conditional}
\alias{Granger.conditional}
\title{Conditional Granger-causality estimation}
\usage{
Granger.conditional(x, y, z, ic.chosen = "SC", max.lag = min(4,
  length(x) - 1), plot = F, type.chosen = "none", p1 = 0, p2 = 0)
}
\arguments{
\item{x}{univariate time series.}

\item{y}{univariate time series (of the same length of \verb{x}).}

\item{z}{univariate time series (of the same length of \verb{x}).}

\item{ic.chosen}{estimation method parameter \verb{ic} to be passed to function \link[vars]{VAR} of
package \href{https://CRAN.R-project.org/package=vars}{vars}. Defaults to ''SC'' (Schwarz criterion). Alternatives are \verb{c(''AIC'',''HQ'',''SC'',''FPE'')}.}

\item{max.lag}{maximum number of lags \verb{lag.max} to be passed to function \code{\link[vars]{VAR}}.
Defaults to \verb{min(4, length(x) - 1)}.}

\item{plot}{logical; if TRUE, it returns the plot of conditional Granger-causality
spectrum. Defaults to FALSE.}

\item{type.chosen}{parameter \verb{type} to be passed to function \code{\link[vars]{VAR}}.
Defaults to \verb{''none''}. Alternatives are \verb{c(''none'',''const'',''trend'')}.}

\item{p1}{parameter \verb{p} to be passed to function \link[vars]{VAR}.
It corresponds to the number of lags of the first VAR model. Defaults to 0.}

\item{p2}{parameter \verb{p} to be passed to function \link[vars]{VAR}.
It corresponds to the number of lags of the second VAR model. Defaults to 0.}
}
\value{
\verb{frequency}: frequencies used by Fast Fourier Transform.

\verb{n}: time series length.

\verb{Conditional_causality_y.to.x.on.z}:  computed conditional Granger-causality from \verb{y} to \verb{x} on \verb{z}.

\verb{roots_1}: the roots of the estimated VAR on \verb{x} and \verb{y}.

\verb{roots_2}: the roots of the estimated VAR on \verb{x}, \verb{y} and \verb{z}.

The result is returned invisibly if plot is TRUE.
}
\description{
Conditional Granger-causality spectrum was first defined in Geweke (1984). It
	measures the strength of the causal link from time series \verb{y} to time series \verb{x} once
	removed the mediating effect of \verb{z} in the frequency domain. Differently from function
	\code{\link[grangers]{Granger.unconditional}}, this function provides only the unidirectional
	causality from \verb{y} to \verb{x}. Here we need to estimate two VAR models: the first on \verb{x} and \verb{z}, the
	second on \verb{x}, \verb{y}, \verb{z}, by package \href{https://CRAN.R-project.org/package=vars}{vars}. Parameters specified for function VAR hold for
	both estimations. For computational details we refer to Ding et al. (2006).
}
\details{
\verb{Granger.conditional} calculates the Granger-causality conditional spectrum of a
	time series \verb{x} (effect variable) on a time series \verb{z} (conditioning variable) respect
to a time series \verb{y} (cause variable). It requireNamespaces package \href{https://CRAN.R-project.org/package=vars}{vars}.
}
\examples{
	RealGdp.rate.ts<-euro_area_indicators[,1]
	m3.rate.ts<-euro_area_indicators[,2]
	hicp.rate.ts<-euro_area_indicators[,4]
	cond_m3.to.gdp.by.hicp<-
Granger.conditional(RealGdp.rate.ts,m3.rate.ts,hicp.rate.ts,"SC",4)
}
\references{
Geweke J., 1984. Measures of conditional linear dependence
	and feedback between time series. \emph{J. Am. Stat. Assoc}. \bold{79}, 907--915.

Ding, M., Chen, Y., Bressler, S.L., 2006. Granger Causality: Basic Theory and
	Application to Neuroscience, Chap.17. \emph{Handbook of Time Series Analysis
	Recent Theoretical Developments and Applications}.

Farne', M., Montanari, A., 2018. A bootstrap test to detect prominent Granger-causalities across frequencies. 
<arXiv:1803.00374>, \emph{Submitted}.
}
\seealso{
\code{\link[vars]{VAR}}.
}
\author{
Matteo Farne', \email{matteo.farne2@unibo.it}
}
