% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReplaceInExpression.R
\name{ReplaceInExpression}
\alias{ReplaceInExpression}
\title{Replace as sub-expression isnide an expression}
\usage{
ReplaceInExpression(expr, what, replacer.func, ...)
}
\arguments{
\item{expr}{An \code{\link{expression}}.}

\item{what}{A backquoted expression to find in \code{expr}.}

\item{replacer.func}{A \code{function(x, ...)} to process the subexpression.}

\item{...}{Other parameters passed to \code{replacer.func}.}
}
\value{
An expression
}
\description{
Replace every subexpression equal to or starting with \code{what} in \code{expr}.
Replacement is performed by passing the whole subexpression to \code{replacer.func},
which should be a \code{function(x, ...)}, where \code{x} is the expression and return the desirable expression.
}
\details{
This function was designed to be used as a runtime processing tool for
grammar generated expression. This allows the user to modify the resulting
expression on the fly based on runtime variables, without including them
in the grammar. See examples section.
}
\examples{
expr = expression(function(x) {
    cbind(f1(x),
          f2(x),
          g3(y))
})
expr
ReplaceInExpression(expr, bquote(f2), function(x) {NULL})
ReplaceInExpression(expr, bquote(f2), function(x) {bquote(f2(y))})
ReplaceInExpression(expr, bquote(g3), function(x) {bquote(f3(x))})
ReplaceInExpression(expr, bquote(g3), function(x, b) {if (b > 1) x else NULL}, b = 0)
ReplaceInExpression(expr, bquote(g3), function(x, b) {if (b > 1) x else NULL}, b = 2)
}
\references{
See \url{http://adv-r.had.co.nz/Expressions.html} by Hadley Wickham.
}

