% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grainscape-package.R
\docType{package}
\name{grainscape-package}
\alias{grainscape}
\alias{grainscape-package}
\title{Landscape Connectivity, Habitat, and Protected Area Networks}
\description{
Given a landscape resistance surface, creates minimum planar graph and
grains of connectivity models that can be used to calculate effective
distances for landscape connectivity at multiple scales.
}
\details{
Landscape connectivity modelling to understand the movement and dispersal of
organisms has been done using raster resistance surfaces and landscape graph methods.
Grains of connectivity (GOC) models combine elements of both approaches to produce
a continuous and scalable tool that can be applied in a variety of study systems.
The purpose of this package is to implement grains of connectivity analyses.
Routines accept raster-based resistance surfaces as input and return raster,
vector and graph-based data structures to represent connectivity at multiple scales.
Effective distances describing connectivity between geographic locations can
be determined at multiple scales.
Analyses of this sort can contribute to corridor identification, landscape genetics,
as well as other connectivity assessments.
Minimum planar graph (MPG; Fall \emph{et al.}, 2007) models of resource patches on
landscapes can also be generated using the software.

MPG calculations and generalization of the Voronoi tessellation used in GOC models
is based on the routines in SELES software (Fall and Fall, 2001).
Routines also depend on the \pkg{sp} (Pebesma and Bivand, 2005),
\pkg{raster} (Hijmans and van Etten, 2011), and \pkg{igraph} (Csardi and Nepusz, 2006) packages.

A paper describing the use of this package for landscape connectivity modelling is
available at \doi{10.1111/2041-210X.13350}.

A detailed tutorial is available as a vignette (see \code{browseVignettes('grainscape')}).
}
\references{
Csardi, G. and T. Nepusz. (2006). The igraph software package for complex network research.
InterJournal Complex Systems 1695. \url{https://igraph.org}.

Fall, A. and J. Fall. (2001). A domain-specific language for models of landscape dynamics.
Ecological Modelling 141:1-18.

Fall, A., M.-J. Fortin, M. Manseau, D. O'Brien. (2007) Spatial graphs: Principles
and applications for habitat connectivity. Ecosystems 10:448:461.

Galpern, P., M. Manseau. (2013a) Finding the functional grain: comparing methods
for scaling resistance surfaces. Landscape Ecology 28:1269-1291.

Galpern, P., M. Manseau. (2013b) Modelling the influence of landscape connectivity
on animal distribution: a functional grain approach. Ecography 36:1004-1016.

Galpern, P., M. Manseau, A. Fall. (2011)  Patch-based graphs of landscape connectivity:
A guide to construction, analysis and application for conservation.
Biological Conservation 144:44-55.

Galpern, P., M. Manseau, P.J. Wilson. (2012) Grains of connectivity: analysis
at multiple spatial scales in landscape genetics. Molecular Ecology 21:3996-4009.

Hijmans, R.J. (2023). raster: Geographic Data Analysis and Modeling.
R package version 3.6-20, \url{https://CRAN.R-project.org/package=raster}.

Pebesma, E.J. and R.S. Bivand. (2005). Classes and methods for spatial data in R.
R News 5 (2), \url{https://cran.r-project.org/doc/Rnews/}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://www.alexchubaty.com/grainscape/}
  \item \url{https://github.com/achubaty/grainscape}
  \item Report bugs at \url{https://github.com/achubaty/grainscape/issues}
}

}
\author{
\strong{Maintainer}: Alex M Chubaty \email{achubaty@for-cast.ca} (\href{https://orcid.org/0000-0001-7146-8135}{ORCID})

Authors:
\itemize{
  \item Paul Galpern \email{pgalpern@gmail.com} (\href{https://orcid.org/0000-0003-0099-3981}{ORCID}) [copyright holder]
  \item Sam Doctolero \email{sam.doctolero@gmail.com}
}

}
\keyword{connectivity}
\keyword{graph}
\keyword{minimum}
\keyword{planar}
\keyword{spatial}
