% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_prompt.R
\name{prepare_chat_history}
\alias{prepare_chat_history}
\title{Prepare chat completion prompt}
\usage{
prepare_chat_history(
  history = NULL,
  style = getOption("gptstudio.code_style"),
  skill = getOption("gptstudio.skill"),
  task = "coding",
  custom_prompt = NULL
)
}
\arguments{
\item{history}{A list of previous messages in the conversation. This can include
roles such as 'system', 'user', or 'assistant'. System messages are discarded.
Default is NULL.i}

\item{style}{The style of code to use. Applicable styles can be
retrieved from the "gptstudio.code_style" option. Default is the
"gptstudio.code_style" option. Options are "base", "tidyverse", or
"no preference".}

\item{skill}{The skill level of the user for the chat conversation. This
can be set through the "gptstudio.skill" option. Default is the
"gptstudio.skill" option. Options are "beginner", "intermediate",
"advanced", and "genius".}

\item{task}{Specifies the task that the assistant will help with. Default is
"coding". Others are "general", "advanced developer", and "custom".}

\item{custom_prompt}{This is a custom prompt that may be used to guide the AI in
its responses. Default is NULL. It will be the only content provided to the
system prompt.}
}
\value{
A list where the first entry is an initial system message followed by any
non-system entries from the chat history.
}
\description{
This function prepares the chat completion prompt to be sent to the OpenAI API.
It also generates a system message according to the given parameters and inserts
it at the beginning of the conversation.
}
