% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_to_line.R
\name{point_to_line}
\alias{point_to_line}
\title{Data.frame with coordinates of points to sf with coordinates of line}
\usage{
point_to_line(
  data = NULL,
  col_long = "long",
  col_lat = "lat",
  crs_proj = "+proj=longlat +datum=WGS84"
)
}
\arguments{
\item{data}{Data frame containing coordinates of points to convert to lines}

\item{col_long}{String containing the name of the column containing the longitude}

\item{col_lat}{String containing the name of the column containing the latitude}

\item{crs_proj}{String containing the proj4string}
}
\value{
returns a sf object with coordinates of line.
}
\description{
Allows converting data.frame with coordinates of points into sf with coordinates of line.
}
\examples{
path.file.ex <- base::system.file("extdata", "df_gps.csv", package = "gps.track")
df.gps <- read.table(path.file.ex,h=TRUE)


df.gps.line <-
point_to_line(
  data = df.gps,
  col_long = "long",
  col_lat = "lat",
  crs_proj = "+proj=longlat +datum=WGS84"
)


}
