% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_gps.R
\name{path_gps}
\alias{path_gps}
\title{GPS track point information extraction.}
\usage{
path_gps(
  filename = NULL,
  layer = "track_points",
  time_zone = "Etc/GMT-0",
  zone_correction = "Etc/GMT+3",
  arq_type = c("shp", "gpx")
)
}
\arguments{
\item{filename}{string designating the file .gpx or .shp path in geographic coordinates}

\item{layer}{string that designates the layer with the trackpoint data when arq_type = "gpx", in case arq_type = "shp" layer is ignored}

\item{time_zone}{string designating the gps default time zone}

\item{zone_correction}{string designating the time zone for correction}

\item{arq_type}{string that designates whether the file is type "shp" or "gpx", "shp" default}
}
\value{
returns a data frame with information about time, coordinates, elevation, distance, speed, elevation difference and azimuth (always calculated in relation to the later point)
}
\description{
Allows extracting and generating new information from track points data collected with GPS.
}
\examples{


path.file.ex <- base::system.file("extdata", "trajeto_teste.shp", package = "gps.track")
df.gps <-
path_gps(
  filename = path.file.ex,
  time_zone = "Etc/GMT-0",
  zone_correction = "Etc/GMT+3",
  arq_type = "shp"
)


}
