% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{gpo_collections}
\alias{gpo_collections}
\title{Retrieve GPO collections data}
\usage{
gpo_collections(
  collection = NULL,
  start_date = NULL,
  end_date = NULL,
  page_size = 10,
  doc_class = NULL,
  congress = NULL,
  bill_version = NULL,
  court_code = NULL,
  court_type = NULL,
  state = NULL,
  topic = NULL,
  is_glp = NULL,
  nature_suit_code = NULL,
  nature_suit = NULL,
  offset_mark = "*"
)
}
\arguments{
\item{collection}{The collectionCode that you want to retrieve (e.g. BILLS, CREC, FR, PLAW, USCOURTS)}

\item{start_date}{ISO8601 date and time formatted string (yyyy-MM-dd'T'HH:mm:ss'Z') Example: 2018-01-28T20:18:10Z}

\item{end_date}{ISO8601 date and time formatted string (yyyy-MM-dd'T'HH:mm:ss'Z') Example: 2018-01-28T20:18:10Z}

\item{page_size}{The number of records to return for a given request.}

\item{doc_class}{Filter by collection-specific categories, which vary among collections.}

\item{congress}{Filter by Congress, e.g., 116, 117}

\item{bill_version}{Specific to the \code{BILLS} collection. Filter by bill text version code.}

\item{court_code}{\code{USCOURTS}collection specific.}

\item{court_type}{\code{USCOURTS} collection specific.}

\item{state}{Collection specific.}

\item{topic}{Collection specific.}

\item{is_glp}{Collection specific.}

\item{nature_suit_code}{Collection specific.}

\item{nature_suit}{Collection specific.}

\item{offset_mark}{Indicates starting record for a given request.}
}
\value{
A tibble
}
\description{
The following params correspond to those listed in the \href{https://www.govinfo.gov/}{GovInfo} API documentation],
but the \code{offset} param is not supported. GovInfo documentation indicates that it was to be deprecated in December,
2022, and though it is still available through the API, the \code{offsetMark} parameter is supported instead. Parameter
descriptions are adapted from \href{https://www.govinfo.gov/}{GovInfo} API documentation.
}
\details{
Calling \code{gpo_collections()} without specifying a collection returns metadata about all collections.
}
\examples{
\dontshow{if (govinfoR::has_govinfo_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

gpo_collections(collection = "BILLS", start_date = "2024-02-17T00:00:00Z")
gpo_collections()
\dontshow{\}) # examplesIf}
}
