% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kenyachoice.R
\docType{data}
\name{kenyachoice}
\alias{kenyachoice}
\title{Kenyan farmers’ preferences for agricultural and livelihood practices}
\format{
A list with two dataframes. \code{kenyachoice[["contests"]]} contains 
 the pairwise rankings from farmers choices. \code{kenyachoice[["predictors"]]}
 contains the socioeconomic data for each farmer.
 Codes for contests are described:
 \describe{
 \item{\code{B}}{Opening a business}
 \item{\code{D}}{Dry planting}
 \item{\code{G}}{Collective crop marketing}
 \item{\code{J}}{Finding off-farm job}
 \item{\code{M}}{Machine tillage}
 \item{\code{O}}{Renting out traction animals}
 \item{\code{R}}{Mulching}
 \item{\code{T}}{Terracing}
 \item{\code{Z}}{Zai pits}  
 }
}
\source{
Steinke, J., et. al. (2019). 
Computers and Electronics in Agriculture, 162, 991–1000.
\doi{https://doi.org/10.1016/j.compag.2019.05.026}
}
\usage{
kenyachoice
}
\description{
Data from a preference experiment in Makueni County, Kenya. Twenty-six 
 smallholder farmers ordered 9 different livelihood improvement practices
 by their personal preference. Full rankings were broken down into 
 multiple pairwise rankings (\code{kenyachoice[["contests"]]}). To each 
 respondent, a set of nine socio-economic variables is available 
 (\code{kenyachoice[["predictors"]]}).
}
\keyword{dataset}
