% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_geocode.R
\name{google_geocode}
\alias{google_geocode}
\title{Google geocoding}
\usage{
google_geocode(
  address,
  bounds = NULL,
  key = get_api_key("geocode"),
  language = NULL,
  region = NULL,
  components = NULL,
  simplify = TRUE,
  curl_proxy = NULL
)
}
\arguments{
\item{address}{\code{string}. The street address that you want to geocode, in the
format used by the national postal service of the country concerned}

\item{bounds}{list of two, each element is a vector of lat/lon coordinates
representing the south-west and north-east bounding box}

\item{key}{\code{string}. A valid Google Developers Geocode API key}

\item{language}{\code{string}. Specifies the language in which to return the results.
See the list of supported languages:
\url{https://developers.google.com/maps/faq#using-google-maps-apis}. If no
langauge is supplied, the service will attempt to use the language of the domain
from which the request was sent}

\item{region}{\code{string}. Specifies the region code, specified as a ccTLD
("top-level domain"). See region basing for details
\url{https://developers.google.com/maps/documentation/directions/overview#RegionBiasing}}

\item{components}{\code{data.frame} of two columns, component and value. Restricts
the results to a specific area. One or more of "route","locality","administrative_area",
"postal_code","country"}

\item{simplify}{\code{logical} - TRUE indicates the returned JSON will be coerced into a list. FALSE indicates the returend JSON will be returned as a string}

\item{curl_proxy}{a curl proxy object}
}
\value{
Either list or JSON string of the geocoded address
}
\description{
Geocoding is the process of converting addresses (like "1600 Amphitheatre
Parkway, Mountain View, CA") into geographic coordinates (like latitude 37.423021
and longitude -122.083739), which you can use to place markers on a map, or position the map.
}
\section{API use and limits}{


The amount of queries you can make to Google's APIs is dependent on both the service
and the API you are using.

Each API has specific quotas and limits. Check Google's API documentation for details.

View your usage at the Google Cloud Console \url{https://console.cloud.google.com/}

Each API can only accept and return one request at a time. If you write a loop
to make multiple API calls you should ensure you don't go over your quota / limits
during the loop.
}

\examples{
\dontrun{

set_key("YOUR_GOOGLE_API_KEY")
df <- google_geocode(address = "MCG, Melbourne, Australia",
                     simplify = TRUE)

df$results$geometry$location
        lat      lng
1 -37.81659 144.9841

## using bounds
bounds <- list(c(34.172684,-118.604794),
               c(34.236144,-118.500938))

js <- google_geocode(address = "Winnetka",
                     bounds = bounds,
                     simplify = FALSE)

## using components
components <- data.frame(component = c("postal_code", "country"),
                         value = c("3000", "AU"))

df <- google_geocode(address = "Flinders Street Station",
                   components = components,
                   simplify = FALSE)

}
}
