% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_make_raster.R
\name{gt_make_raster}
\alias{gt_make_raster}
\title{Make Google Traffic Raster}
\usage{
gt_make_raster(
  location,
  height,
  width,
  zoom,
  google_key,
  traffic_color_dist_thresh = 4.6,
  traffic_color_dist_metric = "CIEDE2000",
  webshot_zoom = 1,
  webshot_delay = NULL,
  print_progress = TRUE
)
}
\arguments{
\item{location}{Vector of latitude and longitude}

\item{height}{Height (in pixels; pixel length depends on zoom)}

\item{width}{Width (in pixels; pixel length depends on zoom)}

\item{zoom}{Zoom level; integer from 5 to 20. For more information about how zoom levels correspond to pixel size, see \href{https://wiki.openstreetmap.org/wiki/Zoom_levels}{here} and \href{https://developers.google.com/maps/documentation/javascript/overview#zoom-levels}{here}.}

\item{google_key}{Google API key, where the \href{https://developers.google.com/maps/documentation/javascript/overview}{Maps JavaScript API} is enabled. To create a Google API key, follow \href{https://developers.google.com/maps/get-started#create-project}{these instructions}.}

\item{traffic_color_dist_thresh}{Google traffic relies on four main base colors: \verb{#63D668} for no traffic, \verb{#FF974D} for medium traffic, \verb{#F23C32} for high traffic, and \verb{#811F1F} for heavy traffic. Slight variations of these colors can also represent traffic. By default, the base colors and all colors within a 4.6 color distance of each base color are used to define traffic; by default, the \code{CIEDE2000} metric is used to determine color distance. A value of 2.3 is one threshold used to define a "just noticeable distance" (JND) between colors (by default, 2 X JND is used). This parameter changes the color distance from the base colors used to define colors as traffic. For more information, see \href{https://en.wikipedia.org/wiki/Color_difference#CIEDE2000}{here}.}

\item{traffic_color_dist_metric}{See above; this parameter changes the metric used to calculate distances between colors. By default, \code{CIEDE2000} is used; \code{CIE76} and \code{CIE94} can also be used. For more information, see \href{https://en.wikipedia.org/wiki/Color_difference#CIEDE2000}{here}.}

\item{webshot_zoom}{How many pixels should be created relative to height and width values. If \code{height} and \code{width} are set to \code{100} and \code{webshot_zoom} is set to \code{2}, the resulting raster will have dimensions of about \verb{200x200} (default: \code{1}).}

\item{webshot_delay}{How long to wait for Google traffic layer to render. Larger height/widths require longer delay times. If \code{NULL}, the following delay time (in seconds) is used: \code{delay = max(height,width)/200}.}

\item{print_progress}{Whether to print function progress (default: \code{TRUE})}
}
\value{
Returns a georeferenced raster. Raster pixels can contain the following values: 1 = no traffic; 2 = medium traffic; 3 = high traffic; 4 = heavy traffic.
}
\description{
Make a raster of \href{https://developers.google.com/maps/documentation/javascript/trafficlayer}{Google traffic data}, where each pixel has one of four values
indicating traffic volume (no traffic, light, moderate, and heavy).
}
\examples{
\dontrun{
r <- gt_make_raster(location   = c(40.712778, -74.006111),
                    height     = 1000,
                    width      = 1000,
                    zoom       = 16,
                    google_key = "GOOGLE-KEY-HERE")
}

}
\references{
Markus Hilpert, Jenni A. Shearston, Jemaleddin Cole, Steven N. Chillrud, and Micaela E. Martinez. \href{https://arxiv.org/abs/2105.12235}{Acquisition and analysis of crowd-sourced traffic data}. CoRR, abs/2105.12235, 2021.

Pavel Pokorny. \href{https://ieeexplore.ieee.org/abstract/document/8326831}{Determining traffic levels in cities using google maps}. In 2017 Fourth International Conference on Mathematics and Computers in Sciences and in Industry (MCSI), pages 144–147, 2017.
}
