% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_read_cells.R
\name{range_read_cells}
\alias{range_read_cells}
\title{Read cells from a Sheet}
\usage{
range_read_cells(
  ss,
  sheet = NULL,
  range = NULL,
  skip = 0,
  n_max = Inf,
  cell_data = c("default", "full"),
  discard_empty = TRUE
)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet:
\itemize{
\item its file id as a string or \code{\link[googledrive:drive_id]{drive_id}}
\item a URL from which we can recover the id
\item a one-row \code{\link[googledrive:dribble]{dribble}}, which is how googledrive
represents Drive files
\item an instance of \code{googlesheets4_spreadsheet}, which is what \code{\link[=gs4_get]{gs4_get()}}
returns
}

Processed through \code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{sheet}{Sheet to read, in the sense of "worksheet" or "tab". You can identify a sheet by name, with a string, or by position, with a number. Ignored if the sheet is specified via \code{range}. If neither argument specifies the sheet, defaults to the first visible sheet.}

\item{range}{A cell range to read from. If \code{NULL}, all non-empty cells are
read. Otherwise specify \code{range} as described in \href{https://developers.google.com/sheets/api/guides/concepts#a1_notation}{Sheets A1 notation}
or using the helpers documented in \link{cell-specification}. Sheets uses
fairly standard spreadsheet range notation, although a bit different from
Excel. Examples of valid ranges: \code{"Sheet1!A1:B2"}, \code{"Sheet1!A:A"},
\code{"Sheet1!1:2"}, \code{"Sheet1!A5:A"}, \code{"A1:B2"}, \code{"Sheet1"}. Interpreted
strictly, even if the range forces the inclusion of leading, trailing, or
embedded empty rows or columns. Takes precedence over \code{skip}, \code{n_max} and
\code{sheet}. Note \code{range} can be a named range, like \code{"sales_data"}, without
any cell reference.}

\item{skip}{Minimum number of rows to skip before reading anything, be it
column names or data. Leading empty rows are automatically skipped, so this
is a lower bound. Ignored if \code{range} is given.}

\item{n_max}{Maximum number of data rows to parse into the returned tibble.
Trailing empty rows are automatically skipped, so this is an upper bound on
the number of rows in the result. Ignored if \code{range} is given. \code{n_max} is
imposed locally, after reading all non-empty cells, so, if speed is an
issue, it is better to use \code{range}.}

\item{cell_data}{How much detail to get for each cell. \code{"default"} retrieves
the fields actually used when googlesheets4 guesses or imposes cell and
column types. \code{"full"} retrieves all fields in the \href{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/cells#CellData}{\code{CellData} schema}.
The main differences relate to cell formatting.}

\item{discard_empty}{Whether to discard cells that have no data. Literally,
we check for an \code{effectiveValue}, which is one of the fields in the
\href{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/cells#CellData}{\code{CellData} schema}.}
}
\value{
A tibble with one row per cell in the \code{range}.
}
\description{
This low-level function returns cell data in a tibble with one row per cell.
This tibble has integer variables \code{row} and \code{col} (referring to location
with the Google Sheet), an A1-style reference \code{loc}, and a \code{cell}
list-column. The flagship function \code{\link[=read_sheet]{read_sheet()}}, a.k.a. \code{\link[=range_read]{range_read()}}, is
what most users are looking for, rather than \code{range_read_cells()}.
\code{\link[=read_sheet]{read_sheet()}} is basically \code{range_read_cells()} (this function), followed by
\code{\link[=spread_sheet]{spread_sheet()}}, which looks after reshaping and column typing. But if you
really want raw cell data from the API, \code{range_read_cells()} is for you!
}
\examples{
\dontshow{if (gs4_has_token()) withAutoprint(\{ # examplesIf}
range_read_cells(gs4_example("deaths"), range = "arts_data")

# if you want detailed and exhaustive cell data, do this
range_read_cells(
  gs4_example("formulas-and-formats"),
  cell_data = "full",
  discard_empty = FALSE
)
\dontshow{\}) # examplesIf}
}
\seealso{
Wraps the \code{spreadsheets.get} endpoint:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/get}
}
}
