% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/folders.R
\name{gtm_folders_update}
\alias{gtm_folders_update}
\title{Updates a GTM Folder}
\usage{
gtm_folders_update(
  account_id,
  container_id,
  workspace_id,
  folder_id,
  name = NULL,
  notes = NULL
)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{folder_id}{Folder Id}

\item{name}{Folder display name}

\item{notes}{User notes on how to apply this folder in the container.}
}
\description{
This updates a folder in the specified workspaces
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 3
folderName <- "New Analytics Tags"
folderNotes <- "All our website's Google Analytics App+Web Tags"

folder <- gtm_folders_update(accountId, containerId, workspaceId, folderName, folderNotes)

}

}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/workspaces/folders/update}

Other folder functions: 
\code{\link{gtm_folders_create}()},
\code{\link{gtm_folders_delete}()},
\code{\link{gtm_folders_entities}()},
\code{\link{gtm_folders_get}()},
\code{\link{gtm_folders_list}()},
\code{\link{gtm_folders_move}()},
\code{\link{gtm_folders_revert}()}
}
\concept{folder functions}
