% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_google_vision_response.R
\name{gcv_get_raw_response}
\alias{gcv_get_raw_response}
\title{Get raw API response from the Google Cloud Vision API}
\usage{
gcv_get_raw_response(imagePaths, feature = "LABEL_DETECTION",
  maxNumResults = NULL)
}
\arguments{
\item{imagePaths}{character, file paths, URLs or Cloud Storage URIs of the images,
can be a combination of all three}

\item{feature}{character, one out of: "LABEL_DETECTION", "FACE_DETECTION",
"TEXT_DETECTION", "DOCUMENT_TEXT_DETECTION", "LOGO_DETECTION", "LANDMARK_DETECTION"}

\item{maxNumResults}{integer, the maximum number of results (per image) to be returned.}
}
\value{
a response object returned by the API. To get the image annotations, take the
  "content" element from the object
}
\description{
Given a list of images, a feature type and the maximum number of responses,
  this functions calls the Google Cloud Vision API, and returns the raw response from the API.
  For a friendlier response, refer to the `gcv_get_image_annotations` function, which returns
  results in a data.table format (however, the information returned is limited compared to the
  raw response).
}
\examples{
\dontrun{
    imagePath <- system.file(
      "extdata", "golden_retriever_puppies.jpg", package = "googleCloudVisionR"
    )
    raw_response <- gcv_get_raw_response(imagePaths = imagePath, maxNumResults = 7)

    str(raw_response)
    raw_response[["content"]]
}

}
