% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_data_source.R
\name{ga_custom_upload}
\alias{ga_custom_upload}
\title{Custom Data Source Upload Status}
\usage{
ga_custom_upload(
  accountId,
  webPropertyId,
  customDataSourceId,
  uploadId,
  upload_object
)
}
\arguments{
\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id}

\item{customDataSourceId}{Custom data source Id}

\item{uploadId}{upload Id}

\item{upload_object}{A custom upload Id object. Supply this or the other arguments.}
}
\value{
An object of class \code{ga_custom_data_source_upload}
}
\description{
Get the status of a custom upload
}
\details{
You can supply either \code{upload_object} generated via function or \link{ga_custom_upload_file}, or make an \code{}
}
\examples{

\dontrun{

upload_me <- data.frame(medium = "shinyapps", 
                        source = "referral", 
                        adCost = 1, 
                        date = "20160801")
                        
obj <- ga_custom_upload_file(47850439, 
                             "UA-4748043-2", 
                             "_jDsJHSFSU-uw038Bh8fUg", 
                             upload_me)
                             
## obj will initially have status = PENDING
obj
==Google Analytics Custom Data Source Upload==
Custom Data Source ID:  _jDsJHSFSU-uw038Bh8fUg 
Account ID:             47850439 
Web Property Id:        UA-4748043-2 
Upload ID:              7yHLAkeLSiK1zveVTiWZwA 
Status:                 PENDING 

## Send obj to ga_custom_upload() to check and renew status
obj <- ga_custom_upload(upload_object = obj)
obj

==Google Analytics Custom Data Source Upload==
Custom Data Source ID:  _jDsJHSFSU-uw038Bh8fUg 
Account ID:             47850439 
Web Property Id:        UA-4748043-2 
Upload ID:              7yHLAkeLSiK1zveVTiWZwA 
Status:                 COMPLETED 

}

}
\seealso{
Other custom datasource functions: 
\code{\link{ga_custom_datasource}()},
\code{\link{ga_custom_upload_delete}()},
\code{\link{ga_custom_upload_file}()},
\code{\link{ga_custom_upload_list}()}
}
\concept{custom datasource functions}
