% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SICM.R
\name{SICM}
\alias{SICM}
\title{Simulated integrated conditional moment test statistic}
\description{
This class inherits from \link{TestStatistic} and implements a
function to calculate the test statistic (and x-y-values that can be used
to plot the underlying process).

The process underlying the test statistic is given in Bierens & Wang
(2012) \doi{10.1017/S0266466611000168} and defined by
\deqn{\hat{T}_n^{(s)}(c) = \frac{1}{(2c)^{p+1}} \int_{[-c,c]^p}
  \int_{-c}^c \left|\frac{1}{\sqrt{n}} \sum_{j=1}^n \Big(\exp(i \tau Y_j) -
  \exp(i \tau \tilde{Y}_j)\Big) \exp(i \xi^T X_j)\right|^2 d\tau d\xi }{(see
  formula given in paper).}
}
\examples{
# Create an example dataset
n <- 100
x <- cbind(runif(n), rbinom(n, 1, 0.5))
model <- NormalGLM$new()
y <- model$sample_yx(x, params=list(beta=c(2,3), sd=1))
data <- dplyr::tibble(x = x, y = y)

# Fit the correct model
model$fit(data, params_init=list(beta=c(1,1), sd=3), inplace = TRUE)

# Print value of test statistic and plot corresponding process
ts <- SICM$new(c = 5)
ts$calc_stat(data, model)
print(ts)
plot(ts)

# Fit a wrong model
model2 <- NormalGLM$new(linkinv = function(u) {u+10})
model2$fit(data, params_init=list(beta=c(1,1), sd=3), inplace = TRUE)

# Print value of test statistic and plot corresponding process
ts2 <- SICM$new(c = 5)
ts2$calc_stat(data, model2)
print(ts2)
plot(ts2)
}
\section{Super class}{
\code{\link[gofreg:TestStatistic]{gofreg::TestStatistic}} -> \code{SICM}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SICM-new}{\code{SICM$new()}}
\item \href{#method-SICM-calc_stat}{\code{SICM$calc_stat()}}
\item \href{#method-SICM-clone}{\code{SICM$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="TestStatistic" data-id="geom_ts_proc"><a href='../../gofreg/html/TestStatistic.html#method-TestStatistic-geom_ts_proc'><code>gofreg::TestStatistic$geom_ts_proc()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="TestStatistic" data-id="get_plot_xy"><a href='../../gofreg/html/TestStatistic.html#method-TestStatistic-get_plot_xy'><code>gofreg::TestStatistic$get_plot_xy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="TestStatistic" data-id="get_value"><a href='../../gofreg/html/TestStatistic.html#method-TestStatistic-get_value'><code>gofreg::TestStatistic$get_value()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="TestStatistic" data-id="plot"><a href='../../gofreg/html/TestStatistic.html#method-TestStatistic-plot'><code>gofreg::TestStatistic$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="gofreg" data-topic="TestStatistic" data-id="print"><a href='../../gofreg/html/TestStatistic.html#method-TestStatistic-print'><code>gofreg::TestStatistic$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SICM-new"></a>}}
\if{latex}{\out{\hypertarget{method-SICM-new}{}}}
\subsection{Method \code{new()}}{
Initialize an instance of class \link{SICM}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SICM$new(
  c,
  transx = function(values) {
     tvals <- atan(scale(values))
     tvals[,
    apply(values, 2, sd) == 0] <- 0
     return(tvals)
 },
  transy = function(values, data) {
     array(atan(scale(values, center = mean(data$y),
    scale = sd(data$y))))
 }
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{c}}{chosen value for integral boundaries (see Bierens & Wang (2012))}

\item{\code{transx}}{\verb{function(values)} used to transform x-values to be
standardized and bounded; default is standardization by subtracting the
mean and dividing by the standard deviation and then applying arctan}

\item{\code{transy}}{\verb{function(values, data)} used to transform y-values to be
standardized and bounded (same method is used for simulated y-values);
default is standardization by subtracting the mean and dividing by the
standard deviation and then applying arctan}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new instance of the class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SICM-calc_stat"></a>}}
\if{latex}{\out{\hypertarget{method-SICM-calc_stat}{}}}
\subsection{Method \code{calc_stat()}}{
Calculate the value of the test statistic for given data
and a model to test for.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SICM$calc_stat(data, model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{\code{data.frame()} with columns x and y containing the data}

\item{\code{model}}{\link{ParamRegrModel} to test for}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The modified object (\code{self}), allowing for method chaining.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SICM-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SICM-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SICM$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
