% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLM.R
\name{GLM.new}
\alias{GLM.new}
\title{Create GLM object with specific distribution family}
\usage{
GLM.new(distr, linkinv = identity, params = NA)
}
\arguments{
\item{distr}{distribution family}

\item{linkinv}{inverse link function, defaults to identity function}

\item{params}{model parameters to use as default (optional)}
}
\value{
a new instance of a GLM-subclass
}
\description{
This constructor function can be used to create an instance of a
parametric GLM with specific distribution family, returning a new object of
\link{NormalGLM}, \link{ExpGLM}, \link{WeibullGLM} or \link{GammaGLM}, depending on the value of
\code{distr}.
}
\examples{
model <- GLM.new(distr = "normal")
# see examples of GLM-subclasses (e.g. NormalGLM) for how to use such models
}
