% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseGoal.R
\name{parseGoal}
\alias{parseGoal}
\title{Parses text describing goal programming problem.}
\usage{
parseGoal(eqs)
}
\arguments{
\item{eqs}{Character vector describing a set of linear equations. The vector
can either contain a single element with one equation per line,
or multiple elements, each with a single equation. Equations must
be valid R expressions (see details).}
}
\value{
List with five elements.
        \itemize{
          \item \code{A}: Numeric matrix with the coefficients of the
                          variables. One row per equation, one column per
                          variable. Columns are named according to the
                          variables they represent. Rows are named for each
                          equation, if a name for them was provided.
          \item \code{b}: Numeric vector with the values on the right
                          hand side of the equations.
          \item \code{m}: Character vector with as many elements as
                          equations. Each element is one of
                          \code{=, ==, <=, >=, <, >}.
          \item \code{w}: Numeric matrix with the weights associated to
                          the deviations of each goal. Each row
                          corresponds to a goal. The first column
                          corresponds to the positive deviation (excess)
                          and the second column to the negative deviation
                          (lack).
          \item \code{p}: Numeric matrix with the lexicographic priority
                          associated to each goal. Lower values
                          represent higher priority. Each row corresponds
                          to a goal. The first column corresponds
                          to the positive deviation (excess) and the second
                          column to the negative deviation (lack).
        }
}
\description{
Given a character vector describing a series of linear equations, it parses
them into an \code{A} numerical matrix describing the variables coefficient
in the left hand size, a \code{b} numerical vector with values on the right
hand size, and an \code{m} character vector indicating the relation between
the left and right hand side (\code{=, ==, <=, >=, <, >}).
}
\details{
This function can only parse linear equations. All variables must be on the
left-hand side, with only numeric values on the right-hand side. Equations
must be valid R expressions. Examples of valid equations are the following:
\itemize{
  \item \code{"3*x + 2*y = 16"}
  \item \code{"4*x -   y =  3"}
}
The following are not valid expressions:
\itemize{
  \item \code{"3*x = 16 - 2*y"}
  \item \code{"4x + 1y = 5"}
}

Signs \code{=} and \code{==} are considered equivalent, and the first will
be replaced by the second after parsing.

Optionally, names, weights and lexicographic priorities can be provided for
each goal (equation) using the following format:
\code{"
Labour   : 20*A + 12*B + 40*C = 1200 | 0.2 0.1 | 1# 2#
Profit   : 11*A + 16*B +  8*C = 1000 | 0.1 0.3 | 3# 4#
Batteries:  4*A +  3*B +  6*C =  200 | 0.2 0.1 | 5# 6#"}
The name of the goal must be followed by a colon (\code{:}) or
vertical bars (\code{|}). Then the goal. Then the weights associated
to the negative deviation first (lack), and the positive deviation (excess)
last, separated by an empty space. Finally, the lexicographic priorities
for the negative (lack) and positive (excess) deviations can be provided
as numbers, each followed by a hashtag (\code{#}), and separated by an
space, in that order. Lower values imply a higher priority, and the same
priority can be assigned to multiple deviations. Only the equation is
mandatory. If the weights are omitted, all of them are assumed to be
equal to one for equations with the \code{=} sign. If the equation is
actually an inequality with \code{>=}, then the default positive (excess)
deviation weight is zero. If \code{<=}, then the default negative (lack)
deviation is zero. If the lexicographic priorities are omitted, all of them
are assumed to be equal to one for equations, but for inequalities \code{>=}
the positive (excess) deviation is given a priority of +Inf (i.e. it will
never be minimised), and for inequalities \code{<=} the negative (lack)
deviation is given a default priority of +Inf (i.e. it will never be
minimised).
}
