% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnomonic-main.R
\docType{package}
\name{gnomonicM-package}
\alias{gnomonicM-package}
\alias{gnomonicM}
\title{Estimate Natural Mortality for Different Life Stages.}
\description{
Estimate natural mortality (M) throughout the life history for organisms, mainly fish and invertebrates, based on gnomonic interval approach. It includes estimation of duration of each gnomonic interval (life stage) and the constant probability of death (G).
}
\details{
Package: gnomonicM

Type: Package

The natural mortality (M) estimation throughout different life stages is based on the gnomonic approach (Caddy, 1991, 1996), including new features in this package-version.

In the gnomonic model, the estimation of \eqn{M_{i}} for each gnomonic interval \eqn{\Delta_{i}} requires -at least- information about:
(i) the number of development stages throughout the life cycle \eqn{i} \eqn{in} \eqn{1,2,3, …n}.
(ii) the duration of the first life stage corresponding to first gnomonic interval (\eqn{\Delta_{1}}, egg stage),
(iii) the mean lifetime fecundity \eqn{MLF}, and
(iv) the longevity of the species. As additional information, the duration of the other developments stages or gnomonic intervals (larval, juvenile, adults) could be provided.

According to Caddy (1996) and Martinez-Aguilar (2005), the gnomonic method is supported by a negative exponential function, where the independent variable is
\eqn{\Delta_{i}} representing the number of gnomonic intervals from \eqn{i} \eqn{in} \eqn{1,2,3, …n}, the equation is expressed as follows:

\deqn{N_{i} = MLF \cdot e^{-(M_{i} \cdot \Delta_{i})};      for i = 1}

\deqn{N_{i} = N_{i-1} \cdot e^{-(M_{i} \cdot \Delta_{i})};       for i > 1}

where:

\eqn{M_{i}} is the average value for natural mortality rate, that integrates the declining death rate through the short time interval duration \eqn{\Delta_{i}}. The \eqn{N_{i}}
is the survivors from previous interval, only for the first interval (\eqn{\Delta_{1}}) is assumed that the numbers of hatching eggs (initial population) is equivalent to
the mean lifetime fecundity (\eqn{MLF}).

The duration of first gnomonic interval \eqn{\Delta_{1}} is equal to the time elapsed after the moment of hatching \eqn{t_{1}}.
The duration of the subsequent gnomonic intervals (\eqn{i > 1}) are estimated following:

\deqn{\Delta_{i} = \Delta_{1} \cdot \alpha  (\alpha + 1)^{i-2}}

where,

\eqn{\Delta_{i}}: Duration of the gnomonic interval when \eqn{i > 1}.

\eqn{\Delta_{1}}: Duration of the first gnomonic interval \eqn{t_{1}}.

\eqn{\alpha}: Proportionality constant.

\eqn{i}: \eqn{i^{th}} gnomonic interval.

The \eqn{M_{i}} is estimated as follows:

\deqn{M_{i} = \frac{G}{\Delta_{i, i-1}}}

where \eqn{G} is the constant proportion of the overall natural death rate. The \eqn{G} value is calculated so that the number  of individuals surviving to the last
gnomonic time-interval is \eqn{N_{n} = 2} following the assumption of stable population replacement (Caddy, 1996; Martinez-Aguilar, 2005).
The new equation for \eqn{G} is expressed:

\deqn{G = -ln((\frac{2}{MLF})^{\frac{1}{n}})}

The final solution is to estimate the proportionality constant (\eqn{\alpha}) parameter by iterative solution via univariate (1-dim.) minimization.
}
\examples{
#See examples for functions gnomonic() and gnomonicStochastic().
}
\references{
Caddy JF (1991). Death rates and time intervals: is there an alternative to the constant natural mortality axiom? Rev Fish Biol Fish 1:109–138. doi:10.1007/BF00157581.

Caddy JF (1996). Modelling natural mortality with age in short-lived invertebrate populations: definition of a strategy of gnomonic time division. Aquat Living Resour 9:197–207. doi:10.1051/alr:1996023.

Martínez-Aguilar S, Arreguín-Sánchez F, Morales-Bojórquez E (2005). Natural mortality and life history stage duration of Pacific sardine (Sardinops caeruleus) based on gnomonic time divisions. Fish Res 71:103–114. doi:10.1016/j.fishres.2004.04.008.
}
\author{
Josymar Torrejon-Magallanes <ejosymart@gmail.com>
}
\concept{fecundity}
\concept{gnomonic}
\concept{lifespan}
\concept{natural mortality}
