% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condb.R
\name{plot.cond.b.joint}
\alias{plot.cond.b.joint}
\title{Plot posterior distribution of the random effects for a \code{joint} model.}
\usage{
\method{plot}{cond.b.joint}(
  x,
  id = NULL,
  show.cov = TRUE,
  nrow = NULL,
  ncol = NULL,
  title = NULL,
  ...
)
}
\arguments{
\item{x}{object of class \code{cond.b.joint} fit by \code{cond.ranefs}.}

\item{id}{integer, if specified this shows the plots the posterior density for the chosen
id (as they appeared in original \code{joint} model fit). By default this takes value 
\code{NULL}, which results in the posterior density for the entire data sample being plotted.}

\item{show.cov}{logical, should the 'true' (normal) density be overlaid on these plots? If 
\code{id} is \emph{not} specified, this overlays a normal density with variance taken from
the \code{joint} fit's value for \eqn{D}. If \code{id} \emph{is} specified, then this overlays
a normal density with variance taken from that subject's \eqn{\hat{\Sigma}_i}, along with an
open circle showing \eqn{\hat{b}_i} from the model fit.}

\item{nrow}{integer specifying the number of rows to use in paneled plot.}

\item{ncol}{integer specifying the number of columns to use in paneled plot. Note that 
\emph{both} \code{nrow} and \code{ncol} must be specified, or neither.}

\item{title}{optional character string to specify the title. This is placed at the top middle of
the graphics device.}

\item{...}{Additional arguments, these are passed to the plotting of the individual densities.}
}
\description{
Plot posterior distribution of the random effects for a \code{joint} model.
}
\examples{
\donttest{
# Bivariate Gaussian 
dat <- simData(n = 100)$data
long.formulas <- list(Y.1 ~ time + cont + bin + (1 + time|id), 
                      Y.2 ~ time + cont + bin + (1 + time|id))
surv.formula <- Surv(survtime, status) ~ bin
fit <- joint(long.formulas, surv.formula, dat, list("gaussian","gaussian"))
cond.b <- cond.ranefs(fit, burnin = 500L, N = 4500L)
# Posterior for entire sample with dummy title
plot(cond.b, title = "Example title")
# Posterior for a randomly selected id
dummy.id <- sample(1:100, 1)
# Should show good agreement between true posterior and approximate normal.
plot(cond.b, id = dummy.id, title = paste0("id: ", dummy.id))
}
}
\keyword{internal}
