% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5-export-.R, R/5-export-music.R
\name{export}
\alias{export}
\alias{export.Music}
\title{Export \code{Music} Object}
\usage{
export(x, ...)

\method{export}{Music}(x, path, musescore = NULL, ...)
}
\arguments{
\item{x}{A \code{Music} object.}

\item{...}{Optional arguments to \code{export()} methods. Should be
ignored by the user.}

\item{path}{A single character, which specifies the output file path.
For example, \code{"my/music/x.mp3"}. See the \emph{Details} section for
supported file extensions.}

\item{musescore}{Optional. A character vector, which represents
the command line options passed to MuseScore. See
\href{https://musescore.org/en/handbook/4/command-line-usage}{MuseScore command line usage} for details.}
}
\value{
An invisible \code{NULL}. A file is generated in the specified path.
}
\description{
Export a \code{Music} object to a file format such as PNG or MP3.
}
\details{
Supported file extensions:
\enumerate{
\item flac
\item metajson
\item mid
\item midi
\item mlog
\item mp3
\item mpos
\item mscx
\item mscz
\item musicxml
\item mxl
\item ogg
\item pdf
\item png
\item spos
\item svg
\item wav
\item xml
}
}
\examples{
if (interactive()) {
  music <- Music() + Meter(4, 4) + Line("C4")
  export(music, tempfile(fileext = ".mp3"), "-r 200 -b 520")
}
}
