% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-turn.R
\name{Turn}
\alias{Turn}
\title{Create \code{Turn} Object}
\usage{
Turn(i, to = NULL, inverted = NULL)
}
\arguments{
\item{i}{A single positive integer, which represents the position
of the turn in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the turn.}

\item{inverted}{Optional. A single logical, which indicates if it is
an inverted turn. The default value is \code{FALSE}. See MusicXML
specification of \href{https://w3c.github.io/musicxml/musicxml-reference/elements/turn/}{turn} and
\href{https://w3c.github.io/musicxml/musicxml-reference/elements/inverted-turn/}{inverted turn}.}
}
\value{
A list of class \code{Turn}.
}
\description{
Create a \code{Turn} object to represent a turn ornament.
}
\examples{
# Create a turn
turn <- Turn(1, inverted = TRUE)
turn

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4")) + turn
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a turn to a \code{Music} object.
}
