% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-tie.R
\name{Tie}
\alias{Tie}
\title{Create \code{Tie} Object}
\usage{
Tie(i, j = NULL, to = NULL, above = NULL)
}
\arguments{
\item{i}{A single positive integer, which represents the start position
of the tie in a musical line.}

\item{j}{Optional. A single positive integer, which represents the
start position of the tie in a chord. If not provided, all notes in the
chords that have equivalent pitches are tied.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the tie.}

\item{above}{Optional. A single logical, which indicates if the tie is
placed above the notes. By default, the position is decided by MuseScore.}
}
\value{
A list of class \code{Tie}.
}
\description{
Create a \code{Tie} to tie some notes together.
}
\examples{
# Create a tie
tie <- Tie(1)
tie

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "C4")) + tie
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a tie to a \code{Music} object.
}
