% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{as_glycan_structure}
\alias{as_glycan_structure}
\title{Convert to Glycan Structure Vector}
\usage{
as_glycan_structure(x)
}
\arguments{
\item{x}{An object to convert to a glycan structure vector.
Can be an igraph object, a list of igraph objects,
a character vector of IUPAC-condensed strings,
or an existing glyrepr_structure object.}
}
\value{
A glyrepr_structure object.
}
\description{
Convert an object to a glycan structure vector.
}
\examples{
library(igraph)

# Convert a single igraph
graph <- make_graph(~ 1-+2)
V(graph)$mono <- c("GlcNAc", "GlcNAc")
V(graph)$sub <- ""
E(graph)$linkage <- "b1-4"
graph$anomer <- "a1"
as_glycan_structure(graph)

# Convert a list of igraphs
o_glycan_vec <- o_glycan_core_1()
o_glycan_graph <- get_structure_graphs(o_glycan_vec)
as_glycan_structure(list(graph, o_glycan_graph))

# Convert a character vector of IUPAC-condensed strings
as_glycan_structure(c("GlcNAc(b1-4)GlcNAc(b1-", "Man(a1-2)GlcNAc(b1-"))

}
