% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{set_style_options}
\alias{set_style_options}
\title{Set general styling options}
\usage{
set_style_options(styling = list())
}
\arguments{
\item{styling}{Named list of styling options for specific elements of glosses.}
}
\description{
This is a helper function to set the configuration that control style characteristics
for glosses across the full document. It is called within \code{\link[=use_glossr]{use_glossr()}}.
}
\details{
There are five types of settings that can be provided in the list.

First, \code{trans_quotes} sets the characters that must surround the free translation in a gloss.
If no value is specified, it will be double quotes. There are no real restrictions
for this value.

Second, the following elements can set general styling instructions for different
sections of a gloss, formatting them completely in italics OR bold. The items with a \code{|}
indicate that various names are possible.×
\itemize{
\item \strong{source|preamble}: The line of the glosses where the \code{source} is rendered.
\item \strong{a|first}: The first line of the glosses, with the original language text.
\item \strong{b|second}: The second line of the glosses.
\item \strong{c|third}: The third line of the glosses if it exists.
\item \strong{ft|trans|translation}: The line of the glosses where the free \code{translation}
is rendered.
}

Each of these items can take one of a few values:
\itemize{
\item \code{i}, \code{it}, \code{italics} and \code{textit} set italics.
\item \code{b}, \code{bf}, \code{bold} and \code{textbf} set boldface.
}

Third, there are a few LaTeX-specific settings documented in the
\href{https://ctan.org/pkg/expex}{expex} documentation.
In all cases the default value is 0 (0pt).
(If you would like other settings to be supported, write up an Issue and I will look into it!)
\itemize{
\item \strong{exskip|par_spacing}: Space above \emph{and} below the example. The \code{par_spacing} name
is allowed for backwards compatibility, but the actual name in \code{expex} is \code{exskip}.
\item \strong{belowglpreambleskip}: Space under the preamble (where the \code{source} is printed).
\item \strong{aboveglftskip}: The spacing above the free translation.
\item \strong{extraglskip}: The spacing between the aligned lines.
}

Fourth, there is one setting that is not available in LaTeX, particularly
thinking of slides: \strong{numbering}, that is,
whether the glosses should be numbered (in HTML).

Finally, you may set the following values for Word output, used in computing
the spaces for alignment:
\itemize{
\item \strong{font_family}: A character vector of length 1 indicating the font family used in the
lines to be aligned, or a list with names "a" and "b" (and "c" if
relevant) indicating the font families of specific lines.
\item \strong{font_size}: A numeric vector of length one indicating the font size used in the
lines to be aligned, or a list with names "a" and "b" (and "c" if
relevant) indicating the font sizes of specific lines.
\item \strong{page_width}: The width of the space between the margins of the Word file,
in pixels, used to wrap long examples. The default is 1332; if you see that your
output does not match what you want, you can tweak it with this value.
}
}
\examples{
set_style_options(styling = list(a = "b", trans_quotes = "'"))
print_config()#'
}
