% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gloss_render.R
\name{gloss_df}
\alias{gloss_df}
\title{Render gloss from a dataframe}
\usage{
gloss_df(df, output_format = config$output, numbering = config$numbering)
}
\arguments{
\item{df}{Dataframe one row per gloss. Columns \code{translation},
\code{source} and \code{label} have special meaning
(see \code{\link[=as_gloss]{as_gloss()}}); all the others will be interpreted as
lines to align in the order given.}

\item{output_format}{(Optional) Whether it will use latex, word or html format.}

\item{numbering}{(Optional) Whether the gloss should be numbered (in Word and HTML).}
}
\value{
Object of class \code{\link[=new_gloss]{gloss}} with the original input as \code{data} attribute.
}
\description{
Render gloss from a dataframe
}
\examples{
my_gloss <- data.frame(
  first_line = "my first line",
  second_line = "my second line",
  translation = "Translation of my example",
  label = "label"
)
gloss_df(my_gloss)
}
