% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmpca.R
\name{predict.glmpca}
\alias{predict.glmpca}
\title{Predict Method for GLM-PCA Fits}
\usage{
\method{predict}{glmpca}(object, ...)
}
\arguments{
\item{object}{a fitted object of class inheriting from \code{glmpca}.}

\item{...}{additional named arguments. Currently ignored.}
}
\value{
a dense \code{matrix} of predicted mean values.
}
\description{
Predict the mean matrix from a fitted generalized principal
  component analysis model object.
}
\details{
Let \code{Y} be the data matrix originally used to estimate the
  parameters in \code{fit}. The GLM-PCA model regards each element of 
  \code{Y} as a random sample from an exponential family distribution 
  such as a Poisson, negative binomial, or binomial likelihood. The 
  components of a GLM-PCA fit are combined to produce the predicted 
  mean of this distribution at each entry of \code{Y}. This matrix may be
  regarded as a 'denoised' version of the original data.
}
\section{Warning}{

  The predicted mean matrix returned by this function
  will have the same dimensions as the original data matrix and it will be
  dense even if the original data were sparse. This can exhaust available
  memory for large datasets, so use with caution.
}

\seealso{
\code{\link{glmpca}}, 
\code{\link[stats]{predict.glm}} with \code{type='response'}
}
