% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.glmnetr_250503.R
\name{plot.cv.glmnetr}
\alias{plot.cv.glmnetr}
\title{Plot cross-validation deviances, or model coefficients.}
\usage{
\method{plot}{cv.glmnetr}(
  x,
  type = "lasso",
  alpha = NULL,
  gamma = NULL,
  lambda.lo = NULL,
  plup = 0,
  title = NULL,
  coefs = FALSE,
  comment = TRUE,
  lty = 1,
  track = 0,
  ...
)
}
\arguments{
\item{x}{a nested.glmnetr()  output object.}

\item{type}{one of c("lasso", "elastic", "ridge") to plot the deviance 
curves of the respective model fit. Default is "lasso" for tuned relaxed lasso.}

\item{alpha}{A specific value of alpha for plotting.  Used only when type is 
set to "elastic". Specifies which alpha is to be used for deviance plots.
Default is "alpha.min", else must be an element of the alpha vector used in 
running the elastic net model. This can be reviewed using summary(fit) 
where fit is a nested.glmnetr() output object. Note, alpha is 1 for the 
lasso model and alpha is 0 for the ridge model.}

\item{gamma}{a specific level of gamma for plotting.  By default gamma.min will be used.}

\item{lambda.lo}{a lower limit of lambda when plotting.}

\item{plup}{an indicator to plot the upper 95 percent two-sided confidence limits.}

\item{title}{a title for the plot.}

\item{coefs}{default of FALSE plots deviances, option of TRUE plots coefficients.}

\item{comment}{default of TRUE to write to console information on lambda and gamma selected for output.
FALSE will suppress this write to console.}

\item{lty}{line type for the cross validated deviances. Default is 1.}

\item{track}{2 to track progress by printing to console, 0 (default) to 
not track.}

\item{...}{Additional arguments passed to the plot function.}
}
\value{
This program returns a plot to the graphics window, and may provide 
some numerical information to the R Console.  If gamma is not specified, then 
then the gamma.min from the deviance minimizing (lambda.min, gamma.min) pair 
will be used, and the corresponding lambda.min will be indicated by a vertical
line, and the lambda minimizing deviance under the restricted set of models 
where gamma=0 will be indicated by a second vertical line.
}
\description{
By default, with coefs=FALSE, plots the average deviances as function of lambda and gamma, and also 
indicates the gamma and lambda which minimize deviance for the lasso, elastic net or ridge model. 
Optionally, with coefs=TRUE, plots the relaxed lasso coefficients.
}
\seealso{
\code{\link{plot.glmnetr}} , \code{\link{plot.nested.glmnetr}}
}
