#'@name sixcitydata
#'@title  sixcitydata -- A very well published Six city data published in many articles including Ware et al (1984), Ibrahim and Lipsitz (1996). Also avaialble
#'in LogXact User Manual. The dataset is a longitudinal study of the health effects of air pollution (ware et al., 1984).
#'
#' @description
#' The 'sixcitydata' dataset contains information on wheezing status, city of residence,
#' maternal smoking habits, socioeconomic status, and medical condition of children at age 11.
#'
#' The dataset includes the following variables:
#' - Wheeze: Binary response variable indicating wheezing status of children at age 11 (1 for wheeze, 0 for no wheeze).
#' - city: Categorical variable indicating city of residence (1 for polluted city, 0 for Portage or Wisconsin).
#' - smoke: Binary variable indicating mother's smoking habits (1 for >20 cigarettes a day, 0 otherwise).
#' - soc: Binary variable indicating high socioeconomic status of subject (1 for high socioecnomic status, 0 otherwise).
#' - cond: Binary variable indicating previous medical condition of subject (1 for previous medical condition, 0 otherwise).
#'

#' @references
#' Cytel Inc (2010). LogXact 9 User Manual: Discrete Regression Analysis. Cambridge, Massachusetts: Cytel Inc.
#'
#' Ibrahim, J. G. (1990). Incomplete data in generalized linear models. Journal of the American Statistical Association 85, 765–769.
#'
#' Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.
#'
#' Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
#'
#' Ware, JH., Dockery, DW., Spiro, A III., Speizer, FE., and Ferris, BG Jr. (1984). Passive smoking, gas cooking, and respiratory health of children living in sex cities. American Review of Respiratory Disease, 129, 366-374.
#'
#' @examples
#'data(sixcitydata)
#' f_fit <- emforbeta(Wheeze ~ city+soc+cond,
#'                    data=sixcitydata,
#'                    family=binomial(link="logit"), method="glm.fit")
#' #creates the summary like glm using the return object mfit
#' summary(f_fit$mfit)
#' vcov_beta<-f_fit$cvcov #creates variance using Louis (1982)
#' se_beta_em<-sqrt(diag(vcov_beta))
#' se_beta_em
#'
"sixcitydata"
