% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glamlasso_RH.R
\name{RH}
\alias{RH}
\alias{glamlasso_RH}
\alias{Rotate}
\alias{H}
\title{The Rotated H-transform of a 3d Array by a Matrix}
\usage{
RH(M, A)
}
\arguments{
\item{M}{a \eqn{n \times p_1} matrix.}

\item{A}{a 3d array of size \eqn{p_1 \times p_2 \times p_3}.}
}
\value{
A 3d array of size \eqn{p_2 \times p_3 \times n}.
}
\description{
This function is an implementation of the \eqn{\rho}-operator found in 
\cite{Currie et al 2006}. It forms the basis of the GLAM arithmetic.
}
\details{
For details see \cite{Currie et al 2006}. Note that this particular implementation 
is not used in the optimization routines underlying the glamlasso procedure.
}
\references{
Currie, I. D., M. Durban, and P. H. C. Eilers (2006). Generalized linear
array models with applications to multidimensional
smoothing. \emph{Journal of the Royal Statistical Society. Series B}. 68, 259-280.
}
\author{
Adam Lund
}
