% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/givitiCalibrationBasic.R
\name{givitiStatCdf}
\alias{givitiStatCdf}
\title{CDF of the Calibration Statistic Under the Null Hypothesis}
\usage{
givitiStatCdf(t, m, devel, thres)
}
\arguments{
\item{t}{The argument of the CDF. Must be a scalar value.}

\item{m}{The scalar integer representing the degree of the polynomial
at the end of the forward selection.}

\item{devel}{A character string specifying if the model has been fit on
the same dataset under evaluation (\code{internal}) or if the model has
been developed on an external sample (\code{external}).}

\item{thres}{A numeric scalar between 0 and 1 representing the
significance level adopted in the forward selection.}
}
\value{
A number representing the value of the CDF evaluated in t.
}
\description{
\code{givitiStatCdf} returns the cumulative density function of the
calibration statistic under the null hypothesis.
}
\examples{
givitiStatCdf(3, 1, "external", .95)
givitiStatCdf(3, 2, "internal", .95)
}
\seealso{
\code{\link{givitiCalibrationBelt}} and \code{\link{plot.givitiCalibrationBelt}}
 to compute and plot the calibaration belt, and
 \code{\link{givitiCalibrationTest}} to perform the
 associated calibration test.
}

