% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects_and_repos.R
\name{gl_list_project_members}
\alias{gl_list_project_members}
\title{List members of a specific project}
\usage{
gl_list_project_members(project, ...)
}
\arguments{
\item{project}{id (preferred way) or name of the project.
Not repository name.}

\item{...}{passed on to \code{\link[=gitlab]{gitlab()}} API call for "project"}
}
\value{
A tibble with the project members information
}
\description{
List members of a specific project
}
\examples{
\dontrun{
set_gitlab_connection(
  gitlab_url = "https://gitlab.com",
  private_token = Sys.getenv("GITLAB_COM_TOKEN")
)
gl_list_project_members(project = "<<your-project-id>>")
}
}
