% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git_commit.R
\name{git_add}
\alias{git_add}
\title{Git Add}
\usage{
git_add()
}
\value{
Invisible NULL
}
\description{
Prints all changed files since last commit and waits for you to hit
ENTER to add everything, or type out the space-separated numbers of
what you do want to add to the next commit, else ESCAPE to cancel.
}
\details{
Files can are selected by number by typing a list of space-separated
values. The inverse can also be used, for example "-2 -4" would add all
\emph{except} the 2nd and 4th file.

Each file or directory is given a symbol for change type:
\itemize{
\item \code{-} has been deleted
\item \code{+} has been created
\item \code{*} has been changed since \code{git_add()} was last called and should be re-added
\item \code{@} has been renamed, but this will often show as a pair of \code{+} and \code{-}
\item \verb{?} contains conflict from latest merge; go in and edit by hand, searching
for "<<<<<<< HEAD" up to ">>>>>>> (some branch)"
}

For any file which has been flagged by \code{git_pull()} or \code{git_merge()} as containing
conflicts, these are \emph{not} included by hitting ENTER and must be added by number.
This is to reduce the risk of accidentally committing a whole load of conflicts.
Each file should be inspected manually before adding.
}
