% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompress_gii.R
\name{decompress_gii}
\alias{decompress_gii}
\title{Decompress Gzipped GIFTI (with extension .gz)}
\usage{
decompress_gii(file)
}
\arguments{
\item{file}{file name of GIFTI file}
}
\value{
Filename of decompressed GIFTI
}
\description{
If a GIFTI file is compressed, as in .gii.gz, this will decompress
the file.  This has nothing to do with the encoding WITHIN the file
}
\examples{
if (have_gifti_test_data(outdir = NULL)) {
   gii_files = download_gifti_data(outdir = NULL)
   outfile = decompress_gii(gii_files[1])
   print(outfile)
}
}
