% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endogenousstats.R
\name{sharedPartner_stat}
\alias{sharedPartner_stat}
\title{Calculate (un-)weighted shared partner change statistics for multi-edge graphs.}
\usage{
sharedPartner_stat(
  graph,
  directed,
  weighted = TRUE,
  triad.type = "undirected",
  nodes = NULL,
  zero_values = NULL
)
}
\arguments{
\item{graph}{A graph adjacency matrix or an edgelist. The edgelist needs to
have 3 columns: a sender vector, a target vector and an edgecount vector.}

\item{directed}{boolean. Is the graph directed?}

\item{weighted}{set to TRUE.}

\item{triad.type}{set to \code{undirected}. Can be set to \code{incoming}
or \code{outgoing} instead. This then corresponds to directed triadic closure
in the multi-edge graph.}

\item{nodes}{optional character/factor vector. If an edgelist is provided,
you have to provide a list of unique identifiers of your nodes in the graph.
This is because in the edgelist, isolates are usually not recorded.
If you do not specify isolates in your nodes object, they are excluded
from the analysis (falsifies data).}

\item{zero_values}{optional numeric value. Use this to substitute zero-values
in your shared partner change statistic matrix. Zero values in the predictors
are recognized in the gHypEG regression as structural zeros. To ensure this
does not happen, please recode your zero-values in all your predictors,
ideally using a dummy variable fitting an optimal value for the zeroes.}
}
\value{
Shared partner change statistic matrix.
}
\description{
The function calculates the change statistic for shared partners for each
dyad in the graph. Shared partner statistics count for each dyad involving
nodes i and j in the graph, how many nodes k these two nodes have in common
(or share). The shared partner $k$ counts are weighted by their
interactions with the focal nodes $i$ and $j$. This is necessary in
dense multi-edge graphs to ensure that meaningful triadic closure is
detected. The statistic can be calculated in 3 different forms: undirected,
incoming shared partners (where shared partner k: k->i and k->j) and outgoing
shared partners (where shared partner k: k<-i and k<-j).
}
\examples{
tri_stat <- sharedPartner_stat(adj_karate, directed = FALSE)
tri_stat_dummy <- get_zero_dummy(tri_stat, name = 'shared_partners')
nrm(w=tri_stat_dummy, adj_karate, directed = FALSE, selfloops = FALSE)
}
\seealso{
\code{\link{reciprocity_stat}} or \code{\link{homophily_stat}}
}
\author{
LB, GC, GV
}
