% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/org_create_assignment.R
\name{org_create_assignment}
\alias{org_create_assignment}
\title{Create a team or individual assignment}
\usage{
org_create_assignment(
  org,
  repo,
  user,
  team = NULL,
  source_repo = NULL,
  private = TRUE,
  add_badges = FALSE
)
}
\arguments{
\item{org}{Character. Name of the GitHub organization.}

\item{repo}{Character. Name of the repo(s) for the assignment.}

\item{user}{Character. GitHub username(s).}

\item{team}{Character. Team names, if not provided an individual assignment will be created.}

\item{source_repo}{Character. Address of the repository to use as a template for all created repos.}

\item{private}{Logical. Should the created repositories be private.}

\item{add_badges}{Logical. Should GitHub action badges be added to the README.}
}
\value{
An invisible list containing the results of each step.
}
\description{
This is a higher level function that combines the following steps:
\itemize{
\item Create repos
\item Create teams and invite students if necessary
\item Add teams or individuals to the repositories
\item Mirror a template repository to assignment repositories
}
}
