% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_potential.R
\docType{data}
\name{geom_potential}
\alias{geom_potential}
\alias{stat_potential}
\alias{StatPotential}
\alias{GeomPotential}
\title{Compute and Plot Potential Function from a Conservative Vector Field}
\usage{
geom_potential(
  mapping = NULL,
  data = NULL,
  stat = StatPotential,
  position = "identity",
  ...,
  na.rm = FALSE,
  inherit.aes = TRUE,
  show.legend = NA,
  fun,
  xlim = NULL,
  ylim = NULL,
  n = 51,
  tol = 1e-06,
  verify_conservative = FALSE
)

stat_potential(
  mapping = NULL,
  data = NULL,
  geom = GeomPotential,
  position = "identity",
  ...,
  na.rm = FALSE,
  inherit.aes = TRUE,
  show.legend = NA,
  fun,
  xlim = NULL,
  ylim = NULL,
  n = 51,
  tol = 1e-06,
  verify_conservative = FALSE
)
}
\arguments{
\item{mapping}{A set of aesthetic mappings created by \code{ggplot2::aes()}.
(Optional)}

\item{data}{The data to be displayed in this layer. If \code{NULL}, data is
inherited from the plot.}

\item{stat}{The statistical transformation to use on the data (default:
\link{StatPotential}).}

\item{position}{Position adjustment, either as a string or the result of a
position adjustment function.}

\item{...}{Other arguments passed to \code{grid::layer()} and underlying
methods.}

\item{na.rm}{Logical. If \code{FALSE} (default), missing values are removed with a
warning.}

\item{inherit.aes}{Logical. If \code{FALSE}, overrides the default aesthetics
rather than combining with them.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{fun}{A function that takes a numeric vector of length 2 (\code{c(x, y)}) and
returns a numeric value, defining the conservative vector field.
\strong{(Required)}}

\item{xlim}{Numeric vector of length 2 defining the domain limits on the
x-axis. Defaults to \code{c(-1, 1)}.}

\item{ylim}{Numeric vector of length 2 defining the domain limits on the
y-axis. Defaults to \code{c(-1, 1)}.}

\item{n}{Integer. Number of grid points along each axis for computing the
potential. Defaults to \code{21}.}

\item{tol}{Numeric. Tolerance for verifying if the vector field is
conservative. Defaults to \code{1e-6}.}

\item{verify_conservative}{Logical. If \code{TRUE}, the function verifies that the
provided vector field is conservative (i.e., that the mixed partial
derivatives are equal within the specified tolerance). Defaults to \code{FALSE}.}

\item{geom}{The geometric object used to render the potential function.
Defaults to \link{GeomPotential}.}
}
\value{
A ggplot2 layer that produces a potential function heatmap.
}
\description{
\code{geom_potential()} adds a raster layer to a ggplot object, visualizing the
potential function derived from a conservative vector field. It computes the
potential numerically over a specified grid and displays it as a heatmap.
}
\details{
Note: the potential is only known up to a constant. The point of reference
used is the lower left corner \code{c(xlim[1], ylim[1])}, where the potential is
assumed to be 0.
}
\section{Aesthetics}{
 \code{geom_potential()} accepts all aesthetics supported by
\code{GeomRaster}. In particular, the key aesthetics include:
\itemize{
\item \strong{fill}: The computed potential value at each grid cell, which is mapped to a color scale.
\item \code{x} and \code{y}: The coordinates of the grid cell centers. (calculated)
\item \code{alpha}: Controls the transparency of the raster fill.
}

Additional raster-specific aesthetics (e.g. those controlled by
\code{scale_fill_gradient()}, \code{scale_fill_viridis_c()}, etc.) can be applied to
modify the appearance of the potential heatmap.
}

\section{Computed Variables}{


The following variable is computed internally by \link{StatPotential} during the
potential function calculation:

\describe{
\item{Potential}{The scalar potential value computed numerically at each grid point.
It represents the accumulated potential from a reference point (typically the lower
bounds of \code{xlim} and \code{ylim}) to the given point. This value is mapped to
the \code{fill} aesthetic in the raster layer.}
}
}

\examples{

\donttest{
scalar_field <- function(u){
  x <- u[1]; y <- u[2]
  (x + y)^2 + 4*(x - y)^2 - 8*(.5)^2
}

gradient_field <- function(u) numDeriv::grad(scalar_field, u)

s <- seq(-1, 1, length.out = 51)

expand.grid("x" = s, "y" = s) |>
  transform(phi = apply(cbind(x, y), 1, scalar_field)) |>
  ggplot(aes(x, y)) + geom_raster(aes(fill = phi))

ggplot() + geom_potential(fun = gradient_field)

ggplot() + geom_potential(fun = gradient_field, verify_conservative = TRUE)
}

}
\keyword{datasets}
