% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsave.R
\name{ggsave}
\alias{ggsave}
\alias{ggsave.gglist}
\alias{ggsave.ggtibble}
\title{Save a plot or list of plots}
\usage{
ggsave(
  filename,
  plot = ggplot2::last_plot(),
  device = NULL,
  path = NULL,
  scale = 1,
  width = NA,
  height = NA,
  units = c("in", "cm", "mm", "px"),
  dpi = 300,
  limitsize = TRUE,
  bg = NULL,
  create.dir = FALSE,
  ...
)

\method{ggsave}{gglist}(
  filename,
  plot,
  device = NULL,
  path = NULL,
  scale = 1,
  width = NA,
  height = NA,
  units = c("in", "cm", "mm", "px"),
  dpi = 300,
  limitsize = TRUE,
  bg = NULL,
  create.dir = FALSE,
  ...
)

\method{ggsave}{ggtibble}(
  filename,
  plot,
  device = NULL,
  path = NULL,
  scale = 1,
  width = NA,
  height = NA,
  units = c("in", "cm", "mm", "px"),
  dpi = 300,
  limitsize = TRUE,
  bg = NULL,
  create.dir = FALSE,
  ...
)
}
\arguments{
\item{filename}{A character string passed to \code{glue::glue_data()} to generate
file names for each row in \code{plot}.}

\item{plot}{Plot to save, defaults to last plot displayed.}

\item{device}{Device to use. Can either be a device function
(e.g. \link{png}), or one of "eps", "ps", "tex" (pictex),
"pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only). If
\code{NULL} (default), the device is guessed based on the \code{filename} extension.}

\item{path}{Path of the directory to save plot to: \code{path} and \code{filename}
are combined to create the fully qualified file name. Defaults to the
working directory.}

\item{scale}{Multiplicative scaling factor.}

\item{width, height}{Plot size in units expressed by the \code{units} argument.
If not supplied, uses the size of the current graphics device.}

\item{units}{One of the following units in which the \code{width} and \code{height}
arguments are expressed: \code{"in"}, \code{"cm"}, \code{"mm"} or \code{"px"}.}

\item{dpi}{Plot resolution. Also accepts a string input: "retina" (320),
"print" (300), or "screen" (72). Only applies when converting pixel units,
as is typical for raster output types.}

\item{limitsize}{When \code{TRUE} (the default), \code{ggsave()} will not
save images larger than 50x50 inches, to prevent the common error of
specifying dimensions in pixels.}

\item{bg}{Background colour. If \code{NULL}, uses the \code{plot.background} fill value
from the plot theme.}

\item{create.dir}{Whether to create new directories if a non-existing
directory is specified in the \code{filename} or \code{path} (\code{TRUE}) or return an
error (\code{FALSE}, default). If \code{FALSE} and run in an interactive session,
a prompt will appear asking to create a new directory when necessary.}

\item{...}{Other arguments passed on to the graphics device function,
as specified by \code{device}.}
}
\description{
Save a plot or list of plots
}
\section{Methods (by class)}{
\itemize{
\item \code{ggsave(gglist)}: Save the figures in a \code{gglist} object

\item \code{ggsave(ggtibble)}: Save the figures in a \code{ggtibble} object

}}
